/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.Span;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.camel.SafeCopyProperty;

public final class ZipkinState
implements SafeCopyProperty {
    public static final String KEY = "CamelZipkinState";
    private final Deque<Span> clientSpans = new ConcurrentLinkedDeque<Span>();
    private final Deque<Span> serverSpans = new ConcurrentLinkedDeque<Span>();

    public ZipkinState() {
    }

    private ZipkinState(ZipkinState state) {
        this.clientSpans.addAll(state.clientSpans);
        this.serverSpans.addAll(state.serverSpans);
    }

    public void pushClientSpan(Span span) {
        this.clientSpans.push(span);
    }

    public Span popClientSpan() {
        if (!this.clientSpans.isEmpty()) {
            return this.clientSpans.pop();
        }
        return null;
    }

    public void pushServerSpan(Span span) {
        this.serverSpans.push(span);
    }

    public Span popServerSpan() {
        if (!this.serverSpans.isEmpty()) {
            return this.serverSpans.pop();
        }
        return null;
    }

    public Span peekServerSpan() {
        if (!this.serverSpans.isEmpty()) {
            return this.serverSpans.peek();
        }
        return null;
    }

    @Override
    public ZipkinState safeCopy() {
        return new ZipkinState(this);
    }
}

