/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.libthrift;

import java.io.Closeable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import zipkin2.reporter.libthrift.InternalScribeCodec;

final class ScribeClient
implements Closeable {
    static final Logger logger = Logger.getLogger(ScribeClient.class.getName());
    static final byte[] category = new byte[]{122, 105, 112, 107, 105, 110};
    final TSocket socket;
    final TBinaryProtocol prot;
    private int seqid_;

    ScribeClient(String host, int port, int socketTimeout, int connectTimeout) {
        this.socket = new TSocket(host, port, socketTimeout, connectTimeout);
        this.prot = new TBinaryProtocol(new TFramedTransport(this.socket));
    }

    static int messageSizeInBytes(int spanSizeInBytes) {
        return InternalScribeCodec.messageSizeInBytes(category, spanSizeInBytes);
    }

    static int messageSizeInBytes(List<byte[]> encodedSpans) {
        return InternalScribeCodec.messageSizeInBytes(category, encodedSpans);
    }

    boolean log(List<byte[]> encodedSpans) throws TException {
        try {
            if (!this.socket.isOpen()) {
                this.socket.open();
            }
            InternalScribeCodec.writeLogRequest(category, encodedSpans, ++this.seqid_, this.prot);
            this.prot.getTransport().flush();
            return InternalScribeCodec.readLogResponse(this.seqid_, this.prot);
        }
        catch (TTransportException e) {
            logger.log(Level.FINE, "Transport exception. recreating socket", e);
            this.socket.close();
            this.seqid_ = 0;
            throw e;
        }
    }

    @Override
    public void close() {
        this.socket.close();
    }
}

