/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.libthrift;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.thrift.TException;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.codec.Encoding;
import zipkin2.reporter.ClosedSenderException;
import zipkin2.reporter.Sender;
import zipkin2.reporter.libthrift.ScribeClient;

public final class LibthriftSender
extends Sender {
    final String host;
    final int port;
    final int messageMaxBytes;
    final int connectTimeout;
    final int socketTimeout;
    private volatile boolean closeCalled;
    private volatile ScribeClient client;

    public static LibthriftSender create(String host) {
        return LibthriftSender.newBuilder().host(host).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    LibthriftSender(Builder builder) {
        if (builder.host == null) {
            throw new NullPointerException("host == null");
        }
        this.host = builder.host;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.port = builder.port;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public Encoding encoding() {
        return Encoding.THRIFT;
    }

    @Override
    public int messageMaxBytes() {
        return this.messageMaxBytes;
    }

    @Override
    public int messageSizeInBytes(int encodedSizeInBytes) {
        return ScribeClient.messageSizeInBytes(encodedSizeInBytes);
    }

    @Override
    public int messageSizeInBytes(List<byte[]> encodedSpans) {
        return ScribeClient.messageSizeInBytes(encodedSpans);
    }

    @Override
    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new ClosedSenderException();
        }
        return new ScribeCall(encodedSpans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScribeClient get() {
        if (this.client == null) {
            LibthriftSender libthriftSender = this;
            synchronized (libthriftSender) {
                if (this.client == null) {
                    this.client = new ScribeClient(this.host, this.port, this.socketTimeout, this.connectTimeout);
                }
            }
        }
        return this.client;
    }

    @Override
    public CheckResult check() {
        try {
            if (this.get().log(Collections.<byte[]>emptyList())) {
                return CheckResult.OK;
            }
            throw new IllegalStateException("try later");
        }
        catch (Exception e) {
            return CheckResult.failed(e);
        }
    }

    @Override
    public void close() {
        if (this.closeCalled) {
            return;
        }
        this.closeCalled = true;
        ScribeClient client = this.client;
        if (client != null) {
            client.close();
        }
    }

    public final String toString() {
        return "LibthriftSender(" + this.host + ":" + this.port + ")";
    }

    class ScribeCall
    extends Call.Base<Void> {
        final List<byte[]> encodedSpans;

        ScribeCall(List<byte[]> encodedSpans) {
            this.encodedSpans = encodedSpans;
        }

        @Override
        protected Void doExecute() throws IOException {
            try {
                if (!LibthriftSender.this.get().log(this.encodedSpans)) {
                    throw new IllegalStateException("try later");
                }
            }
            catch (TException e) {
                throw new IOException(e);
            }
            return null;
        }

        @Override
        protected void doEnqueue(Callback<Void> callback) {
            try {
                if (LibthriftSender.this.get().log(this.encodedSpans)) {
                    callback.onSuccess(null);
                } else {
                    callback.onError(new IllegalStateException("try later"));
                }
                callback.onSuccess(null);
            }
            catch (Error | RuntimeException | TException e) {
                callback.onError(e);
            }
        }

        @Override
        public Call<Void> clone() {
            return new ScribeCall(this.encodedSpans);
        }
    }

    public static final class Builder {
        String host;
        int port = 9410;
        int messageMaxBytes = 500000;
        int connectTimeout = 10000;
        int socketTimeout = 60000;

        Builder(LibthriftSender sender) {
            this.host = sender.host;
            this.messageMaxBytes = sender.messageMaxBytes;
            this.connectTimeout = sender.connectTimeout;
            this.socketTimeout = sender.socketTimeout;
            this.port = sender.port;
        }

        public Builder host(String host) {
            if (host == null) {
                throw new NullPointerException("host == null");
            }
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final LibthriftSender build() {
            return new LibthriftSender(this);
        }

        Builder() {
        }
    }
}

