/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.zookeeper.operations.WatchedEventProvider;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.camel.util.ExchangeHelper;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class ZooKeeperUtils {
    private ZooKeeperUtils() {
    }

    public static CreateMode getCreateMode(Message message, CreateMode defaultMode) {
        CreateMode mode = null;
        try {
            mode = (CreateMode)((Object)message.getHeader("CamelZookeeperCreateMode", CreateMode.class));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mode == null) {
            String modeHeader = (String)message.getHeader("CamelZookeeperCreateMode", String.class);
            mode = ZooKeeperUtils.getCreateModeFromString(modeHeader, defaultMode);
        }
        return mode == null ? defaultMode : mode;
    }

    public static CreateMode getCreateModeFromString(String modeHeader, CreateMode defaultMode) {
        CreateMode mode = null;
        if (modeHeader != null) {
            try {
                mode = CreateMode.valueOf(modeHeader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mode == null ? defaultMode : mode;
    }

    public static String getNodeFromMessage(Message message, String defaultNode) {
        return ZooKeeperUtils.getZookeeperProperty(message, "CamelZooKeeperNode", defaultNode, String.class);
    }

    public static Integer getVersionFromMessage(Message message) {
        return ZooKeeperUtils.getZookeeperProperty(message, "CamelZooKeeperVersion", -1, Integer.class);
    }

    public static byte[] getPayloadFromExchange(Exchange exchange) {
        return (byte[])ExchangeHelper.convertToType((Exchange)exchange, byte[].class, (Object)exchange.getIn().getBody());
    }

    public static List<ACL> getAclListFromMessage(Message in) {
        return ZooKeeperUtils.getZookeeperProperty(in, "CamelZookeeperAcl", ZooDefs.Ids.OPEN_ACL_UNSAFE, List.class);
    }

    public static <T> T getZookeeperProperty(Message m, String propertyName, T defaultValue, Class<? extends T> type) {
        Object value = m.getHeader(propertyName, type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public static WatchedEvent getWatchedEvent(ZooKeeperOperation<?> zooKeeperOperation) {
        WatchedEvent watchedEvent = null;
        if (zooKeeperOperation instanceof WatchedEventProvider) {
            watchedEvent = ((WatchedEventProvider)((Object)zooKeeperOperation)).getWatchedEvent();
        }
        return watchedEvent;
    }

    public static boolean hasWatchedEvent(ZooKeeperOperation<?> zooKeeperOperation) {
        return ZooKeeperUtils.getWatchedEvent(zooKeeperOperation) != null;
    }
}

