/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ssl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.base64.Base64;
import org.jboss.netty.handler.ssl.util.BouncyCastleSelfSignedCertGenerator;
import org.jboss.netty.handler.ssl.util.OpenJdkSelfSignedCertGenerator;
import org.jboss.netty.handler.ssl.util.ThreadLocalInsecureRandom;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;

public final class SelfSignedCertificate {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelfSignedCertificate.class);
    static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    static final Date NOT_AFTER = new Date(253402300799000L);
    private final File certificate;
    private final File privateKey;

    public SelfSignedCertificate() throws CertificateException {
        this("example.com");
    }

    public SelfSignedCertificate(String fqdn) throws CertificateException {
        this(fqdn, ThreadLocalInsecureRandom.current(), 1024);
    }

    public SelfSignedCertificate(String fqdn, SecureRandom random, int bits) throws CertificateException {
        String[] paths;
        KeyPair keypair;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(bits, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        try {
            paths = OpenJdkSelfSignedCertGenerator.generate(fqdn, keypair, random);
        }
        catch (Throwable t2) {
            logger.debug("Failed to generate a self-signed X.509 certificate using sun.security.x509:", t2);
            try {
                paths = BouncyCastleSelfSignedCertGenerator.generate(fqdn, keypair, random);
            }
            catch (Throwable t22) {
                logger.debug("Failed to generate a self-signed X.509 certificate using Bouncy Castle:", t22);
                throw new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.");
            }
        }
        this.certificate = new File(paths[0]);
        this.privateKey = new File(paths[1]);
    }

    public File certificate() {
        return this.certificate;
    }

    public File privateKey() {
        return this.privateKey;
    }

    public void delete() {
        SelfSignedCertificate.safeDelete(this.certificate);
        SelfSignedCertificate.safeDelete(this.privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] newSelfSignedCertificate(String fqdn, PrivateKey key, X509Certificate cert) throws IOException, CertificateEncodingException {
        File certFile;
        File keyFile;
        block7: {
            block6: {
                String keyText = "-----BEGIN PRIVATE KEY-----\n" + Base64.encode(ChannelBuffers.wrappedBuffer(key.getEncoded()), true).toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
                keyFile = File.createTempFile("keyutil_" + fqdn + '_', ".key");
                keyFile.deleteOnExit();
                FileOutputStream keyOut = new FileOutputStream(keyFile);
                try {
                    ((OutputStream)keyOut).write(keyText.getBytes(CharsetUtil.US_ASCII.name()));
                    ((OutputStream)keyOut).close();
                    keyOut = null;
                    Object var7_6 = null;
                    if (keyOut == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (keyOut != null) {
                        SelfSignedCertificate.safeClose(keyFile, keyOut);
                        SelfSignedCertificate.safeDelete(keyFile);
                    }
                    throw throwable;
                }
                SelfSignedCertificate.safeClose(keyFile, keyOut);
                SelfSignedCertificate.safeDelete(keyFile);
            }
            String certText = "-----BEGIN CERTIFICATE-----\n" + Base64.encode(ChannelBuffers.wrappedBuffer(cert.getEncoded()), true).toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            certFile = File.createTempFile("keyutil_" + fqdn + '_', ".crt");
            certFile.deleteOnExit();
            FileOutputStream certOut = new FileOutputStream(certFile);
            try {
                ((OutputStream)certOut).write(certText.getBytes(CharsetUtil.US_ASCII.name()));
                ((OutputStream)certOut).close();
                certOut = null;
                Object var10_11 = null;
                if (certOut == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (certOut != null) {
                    SelfSignedCertificate.safeClose(certFile, certOut);
                    SelfSignedCertificate.safeDelete(certFile);
                    SelfSignedCertificate.safeDelete(keyFile);
                }
                throw throwable;
            }
            SelfSignedCertificate.safeClose(certFile, certOut);
            SelfSignedCertificate.safeDelete(certFile);
            SelfSignedCertificate.safeDelete(keyFile);
        }
        return new String[]{certFile.getPath(), keyFile.getPath()};
    }

    private static void safeDelete(File certFile) {
        if (!certFile.delete()) {
            logger.warn("Failed to delete a file: " + certFile);
        }
    }

    private static void safeClose(File keyFile, OutputStream keyOut) {
        try {
            keyOut.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a file: " + keyFile, e);
        }
    }
}

