/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.zookeepermaster.ContainerIdFactory;
import org.apache.camel.component.zookeepermaster.DefaultContainerIdFactory;
import org.apache.camel.component.zookeepermaster.MasterEndpoint;
import org.apache.camel.component.zookeepermaster.ZookeeperComponentSupport;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.ObjectHelper;

@Component(value="zookeeper-master")
public class MasterComponent
extends ZookeeperComponentSupport {
    @Metadata(label="advanced")
    private ContainerIdFactory containerIdFactory = new DefaultContainerIdFactory();
    @Metadata(defaultValue="/camel/zookeepermaster/clusters/master")
    private String zkRoot = "/camel/zookeepermaster/clusters/master";

    public ContainerIdFactory getContainerIdFactory() {
        return this.containerIdFactory;
    }

    public void setContainerIdFactory(ContainerIdFactory containerIdFactory) {
        this.containerIdFactory = containerIdFactory;
    }

    public String getZkRoot() {
        return this.zkRoot;
    }

    public void setZkRoot(String zkRoot) {
        this.zkRoot = zkRoot;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        int idx = remaining.indexOf(58);
        if (idx <= 0) {
            throw new IllegalArgumentException("Missing : in URI so cannot split the group name from the actual URI for '" + remaining + "'");
        }
        String name = remaining.substring(0, idx);
        String childUri = remaining.substring(idx + 1);
        if (params != null && params.size() > 0) {
            childUri = childUri + "?" + uri.substring(uri.indexOf(63) + 1);
        }
        MasterEndpoint answer = new MasterEndpoint(uri, this, name, childUri);
        return answer;
    }

    protected String getCamelClusterPath(String name) {
        String path = name;
        if (ObjectHelper.isNotEmpty(this.zkRoot)) {
            path = this.zkRoot + "/" + name;
        }
        return path;
    }
}

