/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.zookeepermaster.CamelNodeState;
import org.apache.camel.component.zookeepermaster.MasterEndpoint;
import org.apache.camel.component.zookeepermaster.ZookeeperGroupListenerSupport;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ZooKeeper Master Consumer")
public class MasterConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(MasterConsumer.class);
    private ZookeeperGroupListenerSupport groupListener;
    private final MasterEndpoint endpoint;
    private final Processor processor;
    private Consumer delegate;
    private SuspendableService delegateService;
    private volatile CamelNodeState thisNodeState;

    public MasterConsumer(MasterEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
    }

    @ManagedAttribute(description="Are we connected to ZooKeeper")
    public boolean isConnected() {
        return this.groupListener.getGroup().isConnected();
    }

    @ManagedAttribute(description="Are we the master")
    public boolean isMaster() {
        return this.groupListener.getGroup().isMaster();
    }

    @ManagedOperation(description="Information about all the slaves")
    public String slaves() {
        try {
            return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).writeValueAsString(this.groupListener.getGroup().slaves());
        }
        catch (Exception e) {
            return null;
        }
    }

    @ManagedOperation(description="Information about the last event in the cluster group")
    public String lastEvent() {
        CamelNodeState event = this.groupListener.getGroup().getLastState();
        return event != null ? ((Object)event).toString() : null;
    }

    @ManagedOperation(description="Information about this node")
    public String thisNode() {
        return this.thisNodeState != null ? this.thisNodeState.toString() : null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        String path = this.endpoint.getComponent().getCamelClusterPath(this.endpoint.getGroupName());
        this.groupListener = new ZookeeperGroupListenerSupport(path, this.endpoint, this.onLockOwned(), this.onDisconnected());
        this.groupListener.setCamelContext(this.endpoint.getCamelContext());
        this.groupListener.setZooKeeperUrl(this.endpoint.getComponent().getZooKeeperUrl());
        this.groupListener.setZooKeeperPassword(this.endpoint.getComponent().getZooKeeperPassword());
        this.groupListener.setCurator(this.endpoint.getComponent().getCurator());
        this.groupListener.setMaximumConnectionTimeout(this.endpoint.getComponent().getMaximumConnectionTimeout());
        ServiceHelper.startService((Object)this.groupListener);
        LOG.info("Attempting to become master for endpoint: " + this.endpoint + " in " + this.endpoint.getCamelContext() + " with singletonID: " + this.endpoint.getGroupName());
        this.thisNodeState = this.createNodeState();
        this.groupListener.updateState(this.thisNodeState);
    }

    @Override
    protected void doStop() throws Exception {
        try {
            this.stopConsumer();
        }
        catch (Throwable throwable) {
            ServiceHelper.stopAndShutdownServices(this.groupListener);
            throw throwable;
        }
        ServiceHelper.stopAndShutdownServices(this.groupListener);
        super.doStop();
    }

    private CamelNodeState createNodeState() {
        String containerId = this.endpoint.getComponent().getContainerIdFactory().newContainerId();
        CamelNodeState state = new CamelNodeState(this.endpoint.getGroupName(), containerId);
        state.setConsumer(this.endpoint.getConsumerEndpoint().getEndpointUri());
        return state;
    }

    private void stopConsumer() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.delegate);
        ServiceHelper.stopAndShutdownServices(this.endpoint.getConsumerEndpoint());
        this.delegate = null;
        this.delegateService = null;
        this.thisNodeState = null;
    }

    @Override
    protected void doResume() throws Exception {
        if (this.delegateService != null) {
            this.delegateService.resume();
        }
        super.doResume();
    }

    @Override
    protected void doSuspend() throws Exception {
        if (this.delegateService != null) {
            this.delegateService.suspend();
        }
        super.doSuspend();
    }

    protected Runnable onLockOwned() {
        return () -> {
            if (this.delegate == null) {
                try {
                    LOG.info("Elected as master. Starting consumer: {}", (Object)this.endpoint.getConsumerEndpoint());
                    ServiceHelper.startService((Object)this.endpoint.getConsumerEndpoint());
                    this.delegate = this.endpoint.getConsumerEndpoint().createConsumer(this.processor);
                    this.delegateService = null;
                    if (this.delegate instanceof SuspendableService) {
                        this.delegateService = (SuspendableService)((Object)this.delegate);
                    }
                    this.thisNodeState = this.createNodeState();
                    this.thisNodeState.setStarted(true);
                    this.groupListener.updateState(this.thisNodeState);
                    ServiceHelper.startService((Object)this.delegate);
                }
                catch (Exception e) {
                    LOG.error("Failed to start master consumer for: {}", (Object)this.endpoint, (Object)e);
                }
                LOG.info("Elected as master. Consumer started: {}", (Object)this.endpoint.getConsumerEndpoint());
            }
        };
    }

    protected Runnable onDisconnected() {
        return () -> {
            try {
                this.stopConsumer();
            }
            catch (Exception e) {
                LOG.warn("Failed to stop master consumer for: {}", (Object)this.endpoint, (Object)e);
            }
        };
    }
}

