/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.group.internal.osgi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.component.zookeepermaster.group.ManagedGroupFactory;
import org.apache.camel.component.zookeepermaster.group.NodeState;
import org.apache.camel.component.zookeepermaster.group.internal.DelegateZooKeeperGroup;
import org.apache.camel.component.zookeepermaster.group.internal.DelegateZooKeeperMultiGroup;
import org.apache.curator.framework.CuratorFramework;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OsgiManagedGroupFactory
implements ManagedGroupFactory {
    private ManagedGroupFactory delegate;

    public void setClassLoader(ClassLoader loader) {
        this.delegate = new OsgiTrackingManagedGroupFactory(loader);
    }

    @Override
    public CuratorFramework getCurator() {
        return this.delegate.getCurator();
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
        return this.delegate.createGroup(path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
        return this.delegate.createGroup(path, clazz, threadFactory);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    static class OsgiTrackingManagedGroupFactory
    implements ManagedGroupFactory,
    ServiceTrackerCustomizer<CuratorFramework, CuratorFramework> {
        private final BundleContext bundleContext;
        private final ServiceTracker<CuratorFramework, CuratorFramework> tracker;
        private CuratorFramework curator;
        private final List<DelegateZooKeeperGroup<?>> groups = new ArrayList();

        OsgiTrackingManagedGroupFactory(ClassLoader loader) {
            this(OsgiTrackingManagedGroupFactory.getBundleContext(loader));
        }

        OsgiTrackingManagedGroupFactory(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.tracker = new ServiceTracker(bundleContext, CuratorFramework.class, (ServiceTrackerCustomizer)this);
            this.tracker.open();
        }

        static BundleContext getBundleContext(ClassLoader loader) {
            if (!(loader instanceof BundleReference)) {
                throw new IllegalStateException("Not an OSGi ClassLoader");
            }
            return ((BundleReference)loader).getBundle().getBundleContext();
        }

        public CuratorFramework addingService(ServiceReference<CuratorFramework> reference) {
            CuratorFramework curator = (CuratorFramework)this.bundleContext.getService(reference);
            this.useCurator(curator);
            return curator;
        }

        public void modifiedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
        }

        public void removedService(ServiceReference<CuratorFramework> reference, CuratorFramework service) {
            this.useCurator(null);
            this.bundleContext.ungetService(reference);
        }

        protected void useCurator(CuratorFramework curator) {
            this.curator = curator;
            for (DelegateZooKeeperGroup<?> group : this.groups) {
                group.useCurator(curator);
            }
        }

        @Override
        public CuratorFramework getCurator() {
            return this.curator;
        }

        @Override
        public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
            return new DelegateZooKeeperGroup<T>(path, clazz){

                @Override
                public void start() {
                    this.useCurator(curator);
                    groups.add(this);
                    super.start();
                }

                @Override
                public void close() throws IOException {
                    groups.remove(this);
                    super.close();
                }
            };
        }

        @Override
        public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
            throw new IllegalStateException("not supported");
        }

        @Override
        public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
            return new DelegateZooKeeperMultiGroup<T>(path, clazz){

                @Override
                public void start() {
                    this.useCurator(curator);
                    groups.add(this);
                    super.start();
                }

                @Override
                public void close() throws IOException {
                    groups.remove(this);
                    super.close();
                }
            };
        }

        @Override
        public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
            throw new IllegalStateException("not supported");
        }

        @Override
        public void close() {
            this.tracker.close();
        }
    }
}

