/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.DataInput;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileSegmentInputStream;

public class EncryptedFileSegmentInputStream
extends FileSegmentInputStream
implements FileDataInput,
DataInput {
    private final long segmentOffset;
    private final int expectedLength;
    private final ChunkProvider chunkProvider;
    private int totalChunkOffset;

    public EncryptedFileSegmentInputStream(String filePath, long segmentOffset, int position, int expectedLength, ChunkProvider chunkProvider) {
        super(chunkProvider.nextChunk(), filePath, (long)position);
        this.segmentOffset = segmentOffset;
        this.expectedLength = expectedLength;
        this.chunkProvider = chunkProvider;
    }

    @Override
    public long getFilePointer() {
        return this.segmentOffset + (long)this.totalChunkOffset + (long)this.buffer.position();
    }

    @Override
    public boolean isEOF() {
        return this.totalChunkOffset + this.buffer.position() >= this.expectedLength;
    }

    @Override
    public long bytesRemaining() {
        return this.expectedLength - (this.totalChunkOffset + this.buffer.position());
    }

    @Override
    public void seek(long position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reBuffer() {
        this.totalChunkOffset += this.buffer.position();
        this.buffer = this.chunkProvider.nextChunk();
    }

    public static interface ChunkProvider {
        public ByteBuffer nextChunk();
    }
}

