/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.FileUtils;

public abstract class FileDirectSegment
extends CommitLogSegment {
    protected static final ThreadLocal<ByteBuffer> reusableBufferHolder = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(0);
        }
    };
    static Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    static final int MAX_BUFFERPOOL_SIZE = DatabaseDescriptor.getCommitLogMaxCompressionBuffersInPool();
    volatile long lastWrittenPos = 0L;

    FileDirectSegment(CommitLog commitLog) {
        super(commitLog);
    }

    @Override
    void writeLogHeader() {
        super.writeLogHeader();
        try {
            this.channel.write((ByteBuffer)this.buffer.duplicate().flip());
            this.lastWrittenPos = this.buffer.position();
            this.commitLog.allocator.addSize(this.lastWrittenPos);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    ByteBuffer createBuffer(BufferType bufferType) {
        ByteBuffer buf = bufferPool.poll();
        if (buf != null) {
            buf.clear();
            return buf;
        }
        return bufferType.allocate(DatabaseDescriptor.getCommitLogSegmentSize());
    }

    @Override
    protected void internalClose() {
        if (bufferPool.size() < MAX_BUFFERPOOL_SIZE) {
            bufferPool.add(this.buffer);
        } else {
            FileUtils.clean(this.buffer);
        }
        super.internalClose();
    }

    static void shutdown() {
        bufferPool.clear();
    }
}

