/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.ShortArrayList;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.index.sasi.disk.Descriptor;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.sa.IntegralSA;
import org.apache.cassandra.index.sasi.sa.SA;
import org.apache.cassandra.index.sasi.sa.SuffixSA;
import org.apache.cassandra.index.sasi.sa.TermIterator;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDiskIndexBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OnDiskIndexBuilder.class);
    public static final int BLOCK_SIZE = 4096;
    public static final int MAX_TERM_SIZE = 1024;
    public static final int SUPER_BLOCK_SIZE = 64;
    private final List<MutableLevel<InMemoryPointerTerm>> levels = new ArrayList<MutableLevel<InMemoryPointerTerm>>();
    private MutableLevel<InMemoryDataTerm> dataLevel;
    private final TermSize termSize;
    private final AbstractType<?> keyComparator;
    private final AbstractType<?> termComparator;
    private final Map<ByteBuffer, TokenTreeBuilder> terms;
    private final Mode mode;
    private ByteBuffer minKey;
    private ByteBuffer maxKey;
    private long estimatedBytes;

    public OnDiskIndexBuilder(AbstractType<?> keyComparator, AbstractType<?> comparator, Mode mode) {
        this.keyComparator = keyComparator;
        this.termComparator = comparator;
        this.terms = new HashMap<ByteBuffer, TokenTreeBuilder>();
        this.termSize = TermSize.sizeOf(comparator);
        this.mode = mode;
    }

    public OnDiskIndexBuilder add(ByteBuffer term, DecoratedKey key, long keyPosition) {
        if (term.remaining() >= 1024) {
            logger.error("Rejecting value (value size {}, maximum size {} bytes).", (Object)term.remaining(), (Object)Short.MAX_VALUE);
            return this;
        }
        TokenTreeBuilder tokens = this.terms.get(term);
        if (tokens == null) {
            tokens = new TokenTreeBuilder();
            this.terms.put(term, tokens);
            this.estimatedBytes += (long)(112 + term.remaining());
        }
        tokens.add((Long)key.getToken().getTokenValue(), keyPosition);
        this.minKey = this.minKey == null || this.keyComparator.compare(this.minKey, key.getKey()) > 0 ? key.getKey() : this.minKey;
        this.maxKey = this.maxKey == null || this.keyComparator.compare(this.maxKey, key.getKey()) < 0 ? key.getKey() : this.maxKey;
        this.estimatedBytes += 108L;
        return this;
    }

    public long estimatedMemoryUse() {
        return this.estimatedBytes;
    }

    private void addTerm(InMemoryDataTerm term, SequentialWriter out) throws IOException {
        MutableLevel<InMemoryPointerTerm> level;
        InMemoryPointerTerm ptr = this.dataLevel.add(term);
        if (ptr == null) {
            return;
        }
        int levelIdx = 0;
        while ((ptr = (level = this.getIndexLevel(levelIdx++, out)).add(ptr)) != null) {
        }
    }

    public boolean isEmpty() {
        return this.terms.isEmpty();
    }

    public void finish(Pair<ByteBuffer, ByteBuffer> range, File file, TermIterator terms) {
        this.finish(Descriptor.CURRENT, range, file, terms);
    }

    public boolean finish(File indexFile) throws FSWriteError {
        return this.finish(Descriptor.CURRENT, indexFile);
    }

    @VisibleForTesting
    protected boolean finish(Descriptor descriptor, File file) throws FSWriteError {
        if (this.terms.isEmpty()) {
            return false;
        }
        SA sa = (this.termComparator instanceof UTF8Type || this.termComparator instanceof AsciiType) && this.mode == Mode.CONTAINS ? new SuffixSA(this.termComparator, this.mode) : new IntegralSA(this.termComparator, this.mode);
        for (Map.Entry<ByteBuffer, TokenTreeBuilder> term : this.terms.entrySet()) {
            sa.add(term.getKey(), term.getValue());
        }
        this.finish(descriptor, Pair.create(this.minKey, this.maxKey), file, sa.finish());
        return true;
    }

    protected void finish(Descriptor descriptor, Pair<ByteBuffer, ByteBuffer> range, File file, TermIterator terms) {
        SequentialWriter out = null;
        try {
            out = new SequentialWriter(file, 4096, BufferType.ON_HEAP);
            out.writeUTF(descriptor.version.toString());
            out.writeShort(this.termSize.size);
            ByteBufferUtil.writeWithShortLength(terms.minTerm(), out);
            ByteBufferUtil.writeWithShortLength(terms.maxTerm(), out);
            ByteBufferUtil.writeWithShortLength((ByteBuffer)range.left, out);
            ByteBufferUtil.writeWithShortLength((ByteBuffer)range.right, out);
            out.writeUTF(this.mode.toString());
            out.skipBytes((int)(4096L - out.position()));
            MutableLevel mutableLevel = this.dataLevel = this.mode == Mode.SPARSE ? new DataBuilderLevel(out, new MutableDataBlock(this.mode)) : new MutableLevel<InMemoryDataTerm>(out, new MutableDataBlock(this.mode));
            while (terms.hasNext()) {
                Pair term = (Pair)terms.next();
                this.addTerm(new InMemoryDataTerm((ByteBuffer)term.left, (TokenTreeBuilder)term.right), out);
            }
            this.dataLevel.finalFlush();
            for (MutableLevel mutableLevel2 : this.levels) {
                mutableLevel2.flush();
            }
            long levelIndexPosition = out.position();
            out.writeInt(this.levels.size());
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                this.levels.get(i).flushMetadata();
            }
            this.dataLevel.flushMetadata();
            out.writeLong(levelIndexPosition);
            out.sync();
        }
        catch (IOException e) {
            try {
                throw new FSWriteError((Throwable)e, file);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(out);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(out);
    }

    private MutableLevel<InMemoryPointerTerm> getIndexLevel(int idx, SequentialWriter out) {
        if (this.levels.size() == 0) {
            this.levels.add(new MutableLevel(out, new MutableBlock()));
        }
        if (this.levels.size() - 1 < idx) {
            int toAdd = idx - (this.levels.size() - 1);
            for (int i = 0; i < toAdd; ++i) {
                this.levels.add(new MutableLevel(out, new MutableBlock()));
            }
        }
        return this.levels.get(idx);
    }

    protected static void alignToBlock(SequentialWriter out) throws IOException {
        long endOfBlock = out.position();
        if ((endOfBlock & 0xFFFL) != 0L) {
            out.skipBytes((int)(FBUtilities.align(endOfBlock, 4096) - endOfBlock));
        }
    }

    private static class MutableDataBlock
    extends MutableBlock<InMemoryDataTerm> {
        private final Mode mode;
        private int offset = 0;
        private int sparseValueTerms = 0;
        private final List<TokenTreeBuilder> containers = new ArrayList<TokenTreeBuilder>();
        private TokenTreeBuilder combinedIndex;

        public MutableDataBlock(Mode mode) {
            this.mode = mode;
            this.combinedIndex = new TokenTreeBuilder();
        }

        @Override
        protected void addInternal(InMemoryDataTerm term) throws IOException {
            TokenTreeBuilder keys = term.keys;
            if (this.mode == Mode.SPARSE && keys.getTokenCount() <= 5L) {
                this.writeTerm((InMemoryTerm)term, keys);
                ++this.sparseValueTerms;
            } else {
                this.writeTerm((InMemoryTerm)term, this.offset);
                this.offset += keys.serializedSize();
                this.containers.add(keys);
            }
            if (this.mode == Mode.SPARSE) {
                this.combinedIndex.add(keys.getTokens());
            }
        }

        @Override
        protected int sizeAfter(InMemoryDataTerm element) {
            return super.sizeAfter(element) + this.ptrLength(element);
        }

        @Override
        public void flushAndClear(SequentialWriter out) throws IOException {
            super.flushAndClear(out);
            out.writeInt(this.sparseValueTerms == 0 ? -1 : this.offset);
            if (this.containers.size() > 0) {
                for (TokenTreeBuilder tokens : this.containers) {
                    tokens.write(out);
                }
            }
            if (this.sparseValueTerms > 0) {
                this.combinedIndex.finish().write(out);
            }
            OnDiskIndexBuilder.alignToBlock(out);
            this.containers.clear();
            this.combinedIndex = new TokenTreeBuilder();
            this.offset = 0;
            this.sparseValueTerms = 0;
        }

        private int ptrLength(InMemoryDataTerm term) {
            return term.keys.getTokenCount() > 5L ? 5 : 1 + 8 * (int)term.keys.getTokenCount();
        }

        private void writeTerm(InMemoryTerm term, TokenTreeBuilder keys) throws IOException {
            term.serialize(this.buffer);
            this.buffer.writeByte((byte)keys.getTokenCount());
            Iterator<Pair<Long, LongSet>> tokens = keys.iterator();
            while (tokens.hasNext()) {
                this.buffer.writeLong((Long)tokens.next().left);
            }
        }

        private void writeTerm(InMemoryTerm term, int offset) throws IOException {
            term.serialize(this.buffer);
            this.buffer.writeByte(0);
            this.buffer.writeInt(offset);
        }
    }

    private static class MutableBlock<T extends InMemoryTerm> {
        protected final DataOutputBufferFixed buffer = new DataOutputBufferFixed(4096);
        protected final ShortArrayList offsets = new ShortArrayList();

        public final void add(T term) throws IOException {
            this.offsets.add((short)this.buffer.position());
            this.addInternal(term);
        }

        protected void addInternal(T term) throws IOException {
            ((InMemoryTerm)term).serialize(this.buffer);
        }

        public boolean hasSpaceFor(T element) {
            return this.sizeAfter(element) < 4096;
        }

        protected int sizeAfter(T element) {
            return this.getWatermark() + 4 + ((InMemoryTerm)element).serializedSize();
        }

        protected int getWatermark() {
            return 4 + this.offsets.size() * 2 + (int)this.buffer.position();
        }

        public void flushAndClear(SequentialWriter out) throws IOException {
            out.writeInt(this.offsets.size());
            for (int i = 0; i < this.offsets.size(); ++i) {
                out.writeShort(this.offsets.get(i));
            }
            out.write(this.buffer.buffer());
            OnDiskIndexBuilder.alignToBlock(out);
            this.offsets.clear();
            this.buffer.clear();
        }
    }

    private class DataBuilderLevel
    extends MutableLevel<InMemoryDataTerm> {
        private final LongArrayList superBlockOffsets;
        private int dataBlocksCnt;
        private TokenTreeBuilder superBlockTree;

        public DataBuilderLevel(SequentialWriter out, MutableBlock<InMemoryDataTerm> block) {
            super(out, block);
            this.superBlockOffsets = new LongArrayList();
            this.superBlockTree = new TokenTreeBuilder();
        }

        @Override
        public InMemoryPointerTerm add(InMemoryDataTerm term) throws IOException {
            InMemoryPointerTerm ptr = super.add(term);
            if (ptr != null) {
                ++this.dataBlocksCnt;
                this.flushSuperBlock(false);
            }
            this.superBlockTree.add(term.keys.getTokens());
            return ptr;
        }

        public void flushSuperBlock(boolean force) throws IOException {
            if (this.dataBlocksCnt == 64 || force && !this.superBlockTree.getTokens().isEmpty()) {
                this.superBlockOffsets.add(this.out.position());
                this.superBlockTree.finish().write(this.out);
                OnDiskIndexBuilder.alignToBlock(this.out);
                this.dataBlocksCnt = 0;
                this.superBlockTree = new TokenTreeBuilder();
            }
        }

        @Override
        public void finalFlush() throws IOException {
            super.flush();
            this.flushSuperBlock(true);
        }

        @Override
        public void flushMetadata() throws IOException {
            super.flushMetadata();
            this.flushMetadata(this.superBlockOffsets);
        }
    }

    private class MutableLevel<T extends InMemoryTerm> {
        private final LongArrayList blockOffsets = new LongArrayList();
        protected final SequentialWriter out;
        private final MutableBlock<T> inProcessBlock;
        private InMemoryPointerTerm lastTerm;

        public MutableLevel(SequentialWriter out, MutableBlock<T> block) {
            this.out = out;
            this.inProcessBlock = block;
        }

        public InMemoryPointerTerm add(T term) throws IOException {
            InMemoryPointerTerm toPromote = null;
            if (!this.inProcessBlock.hasSpaceFor(term)) {
                this.flush();
                toPromote = this.lastTerm;
            }
            this.inProcessBlock.add(term);
            this.lastTerm = new InMemoryPointerTerm(((InMemoryTerm)term).term, this.blockOffsets.size());
            return toPromote;
        }

        public void flush() throws IOException {
            this.blockOffsets.add(this.out.position());
            this.inProcessBlock.flushAndClear(this.out);
        }

        public void finalFlush() throws IOException {
            this.flush();
        }

        public void flushMetadata() throws IOException {
            this.flushMetadata(this.blockOffsets);
        }

        protected void flushMetadata(LongArrayList longArrayList) throws IOException {
            this.out.writeInt(longArrayList.size());
            for (int i = 0; i < longArrayList.size(); ++i) {
                this.out.writeLong(longArrayList.get(i));
            }
        }
    }

    private class InMemoryDataTerm
    extends InMemoryTerm {
        private final TokenTreeBuilder keys;

        public InMemoryDataTerm(ByteBuffer term, TokenTreeBuilder keys) {
            super(term);
            this.keys = keys;
        }
    }

    private class InMemoryPointerTerm
    extends InMemoryTerm {
        protected final int blockCnt;

        public InMemoryPointerTerm(ByteBuffer term, int blockCnt) {
            super(term);
            this.blockCnt = blockCnt;
        }

        @Override
        public int serializedSize() {
            return super.serializedSize() + 4;
        }

        @Override
        public void serialize(DataOutputPlus out) throws IOException {
            super.serialize(out);
            out.writeInt(this.blockCnt);
        }
    }

    private class InMemoryTerm {
        protected final ByteBuffer term;

        public InMemoryTerm(ByteBuffer term) {
            this.term = term;
        }

        public int serializedSize() {
            return (OnDiskIndexBuilder.this.termSize.isConstant() ? 0 : 2) + this.term.remaining();
        }

        public void serialize(DataOutputPlus out) throws IOException {
            if (OnDiskIndexBuilder.this.termSize.isConstant()) {
                out.write(this.term);
            } else {
                ByteBufferUtil.writeWithShortLength(this.term, out);
            }
        }
    }

    public static enum TermSize {
        INT(4),
        LONG(8),
        UUID(16),
        VARIABLE(-1);

        public final int size;

        private TermSize(int size) {
            this.size = size;
        }

        public boolean isConstant() {
            return this != VARIABLE;
        }

        public static TermSize of(int size) {
            switch (size) {
                case -1: {
                    return VARIABLE;
                }
                case 4: {
                    return INT;
                }
                case 8: {
                    return LONG;
                }
                case 16: {
                    return UUID;
                }
            }
            throw new IllegalStateException("unknown state: " + size);
        }

        public static TermSize sizeOf(AbstractType<?> comparator) {
            if (comparator instanceof Int32Type || comparator instanceof FloatType) {
                return INT;
            }
            if (comparator instanceof LongType || comparator instanceof DoubleType || comparator instanceof TimestampType || comparator instanceof DateType) {
                return LONG;
            }
            if (comparator instanceof TimeUUIDType || comparator instanceof UUIDType) {
                return UUID;
            }
            return VARIABLE;
        }
    }

    public static enum Mode {
        PREFIX(EnumSet.of(Expression.Op.EQ, Expression.Op.MATCH, Expression.Op.PREFIX, Expression.Op.NOT_EQ, Expression.Op.RANGE)),
        CONTAINS(EnumSet.of(Expression.Op.MATCH, Expression.Op.CONTAINS, Expression.Op.SUFFIX, Expression.Op.NOT_EQ)),
        SPARSE(EnumSet.of(Expression.Op.EQ, Expression.Op.NOT_EQ, Expression.Op.RANGE));

        Set<Expression.Op> supportedOps;

        private Mode(Set<Expression.Op> ops) {
            this.supportedOps = ops;
        }

        public static Mode mode(String mode) {
            return Mode.valueOf(mode.toUpperCase());
        }

        public boolean supports(Expression.Op op) {
            return this.supportedOps.contains((Object)op);
        }
    }
}

