/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongOpenHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class TokenTreeBuilder {
    public static final int BLOCK_BYTES = 4096;
    public static final int BLOCK_HEADER_BYTES = 64;
    public static final int OVERFLOW_TRAILER_BYTES = 64;
    public static final int OVERFLOW_TRAILER_CAPACITY = 8;
    public static final int TOKENS_PER_BLOCK = 248;
    public static final long MAX_OFFSET = 0x7FFFFFFFFFFFL;
    public static final byte LAST_LEAF_SHIFT = 1;
    public static final byte SHARED_HEADER_BYTES = 19;
    public static final byte ENTRY_TYPE_MASK = 3;
    public static final short AB_MAGIC = 23121;
    private final SortedMap<Long, LongSet> tokens = new TreeMap<Long, LongSet>();
    private int numBlocks;
    private Node root;
    private InteriorNode rightmostParent;
    private Leaf leftmostLeaf;
    private Leaf rightmostLeaf;
    private long tokenCount = 0L;
    private long treeMinToken;
    private long treeMaxToken;

    public TokenTreeBuilder() {
    }

    public TokenTreeBuilder(SortedMap<Long, LongSet> data) {
        this.add(data);
    }

    public void add(Long token, long keyPosition) {
        LongSet found = (LongSet)this.tokens.get(token);
        if (found == null) {
            found = new LongOpenHashSet(2);
            this.tokens.put(token, found);
        }
        found.add(keyPosition);
    }

    public void add(SortedMap<Long, LongSet> data) {
        for (Map.Entry<Long, LongSet> newEntry : data.entrySet()) {
            LongSet found = (LongSet)this.tokens.get(newEntry.getKey());
            if (found == null) {
                found = new LongOpenHashSet(4);
                this.tokens.put(newEntry.getKey(), found);
            }
            for (LongCursor offset : newEntry.getValue()) {
                found.add(offset.value);
            }
        }
    }

    public TokenTreeBuilder finish() {
        this.maybeBulkLoad();
        return this;
    }

    public SortedMap<Long, LongSet> getTokens() {
        return this.tokens;
    }

    public long getTokenCount() {
        return this.tokenCount;
    }

    public int serializedSize() {
        if (this.numBlocks == 1) {
            return 64 + (int)this.tokenCount * 16;
        }
        return this.numBlocks * 4096;
    }

    public void write(DataOutputPlus out) throws IOException {
        ByteBuffer blockBuffer = ByteBuffer.allocate(4096);
        Iterator<Node> levelIterator = this.root.levelIterator();
        long childBlockIndex = 1L;
        while (levelIterator != null) {
            Node firstChild = null;
            while (levelIterator.hasNext()) {
                Node block = levelIterator.next();
                if (firstChild == null && !block.isLeaf()) {
                    firstChild = (Node)((InteriorNode)block).children.get(0);
                }
                block.serialize(childBlockIndex, blockBuffer);
                this.flushBuffer(blockBuffer, out, this.numBlocks != 1);
                childBlockIndex += (long)block.childCount();
            }
            levelIterator = firstChild == null ? null : firstChild.levelIterator();
        }
    }

    public Iterator<Pair<Long, LongSet>> iterator() {
        return new TokenIterator(this.leftmostLeaf.levelIterator());
    }

    private void maybeBulkLoad() {
        if (this.root == null) {
            this.bulkLoad();
        }
    }

    private void flushBuffer(ByteBuffer buffer, DataOutputPlus o, boolean align) throws IOException {
        if (align) {
            TokenTreeBuilder.alignBuffer(buffer, 4096);
        }
        buffer.flip();
        o.write(buffer);
        buffer.clear();
    }

    private static void alignBuffer(ByteBuffer buffer, int blockSize) {
        long curPos = buffer.position();
        if ((curPos & (long)(blockSize - 1)) != 0L) {
            buffer.position((int)FBUtilities.align(curPos, blockSize));
        }
    }

    private void bulkLoad() {
        this.tokenCount = this.tokens.size();
        this.treeMinToken = this.tokens.firstKey();
        this.treeMaxToken = this.tokens.lastKey();
        this.numBlocks = 1;
        if (this.tokenCount <= 248L) {
            this.rightmostLeaf = this.leftmostLeaf = new Leaf(this.tokens);
            this.root = this.leftmostLeaf;
        } else {
            this.root = new InteriorNode();
            this.rightmostParent = (InteriorNode)this.root;
            int i = 0;
            Leaf lastLeaf = null;
            Long firstToken = this.tokens.firstKey();
            Long finalToken = this.tokens.lastKey();
            for (Long token : this.tokens.keySet()) {
                Leaf leaf;
                if (i == 0 || i % 248 != 0 && (long)i != this.tokenCount - 1L) {
                    ++i;
                    continue;
                }
                Long lastToken = token;
                Leaf leaf2 = leaf = (long)i != this.tokenCount - 1L || token.equals(finalToken) ? new Leaf(this.tokens.subMap(firstToken, lastToken)) : new Leaf(this.tokens.tailMap(firstToken));
                if (i == 248) {
                    this.leftmostLeaf = leaf;
                } else {
                    lastLeaf.next = leaf;
                }
                this.rightmostParent.add(leaf);
                lastLeaf = leaf;
                this.rightmostLeaf = leaf;
                firstToken = lastToken;
                ++i;
                ++this.numBlocks;
                if (!token.equals(finalToken)) continue;
                Leaf finalLeaf = new Leaf(this.tokens.tailMap(token));
                lastLeaf.next = finalLeaf;
                this.rightmostParent.add(finalLeaf);
                this.rightmostLeaf = finalLeaf;
                ++this.numBlocks;
            }
        }
    }

    public static class TokenIterator
    extends AbstractIterator<Pair<Long, LongSet>> {
        private Iterator<Node> levelIterator;
        private Iterator<Map.Entry<Long, LongSet>> currentIterator;

        TokenIterator(Iterator<Node> level) {
            this.levelIterator = level;
            if (this.levelIterator.hasNext()) {
                this.currentIterator = ((Leaf)this.levelIterator.next()).tokenIterator();
            }
        }

        public Pair<Long, LongSet> computeNext() {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                Map.Entry<Long, LongSet> next = this.currentIterator.next();
                return Pair.create(next.getKey(), next.getValue());
            }
            if (!this.levelIterator.hasNext()) {
                return (Pair)this.endOfData();
            }
            this.currentIterator = ((Leaf)this.levelIterator.next()).tokenIterator();
            return this.computeNext();
        }
    }

    public static class LevelIterator
    extends AbstractIterator<Node> {
        private Node currentNode;

        LevelIterator(Node first) {
            this.currentNode = first;
        }

        public Node computeNext() {
            if (this.currentNode == null) {
                return (Node)this.endOfData();
            }
            Node returnNode = this.currentNode;
            this.currentNode = returnNode.next;
            return returnNode;
        }
    }

    private class InteriorNode
    extends Node {
        private List<Long> tokens;
        private List<Node> children;
        private int position;

        private InteriorNode() {
            this.tokens = new ArrayList<Long>(248);
            this.children = new ArrayList<Node>(249);
            this.position = 0;
        }

        @Override
        public void serialize(long childBlockIndex, ByteBuffer buf) {
            this.serializeHeader(buf);
            this.serializeTokens(buf);
            this.serializeChildOffsets(childBlockIndex, buf);
        }

        @Override
        public int childCount() {
            return this.children.size();
        }

        @Override
        public int tokenCount() {
            return this.tokens.size();
        }

        @Override
        public Long smallestToken() {
            return this.tokens.get(0);
        }

        protected void add(Long token, InteriorNode leftChild, InteriorNode rightChild) {
            int pos = this.tokens.size();
            if (pos == 248) {
                InteriorNode sibling = this.split();
                sibling.add(token, leftChild, rightChild);
            } else {
                if (leftChild != null) {
                    this.children.add(pos, leftChild);
                }
                if (rightChild != null) {
                    this.children.add(pos + 1, rightChild);
                    rightChild.parent = this;
                }
                this.updateTokenRange(token);
                this.tokens.add(pos, token);
            }
        }

        protected void add(Leaf node) {
            if (this.position == 249) {
                TokenTreeBuilder.this.rightmostParent = this.split();
                TokenTreeBuilder.this.rightmostParent.add(node);
            } else {
                node.parent = this;
                this.children.add(this.position, node);
                ++this.position;
                if (this.position - 1 == 0) {
                    return;
                }
                Long smallestToken = node.smallestToken();
                this.updateTokenRange(smallestToken);
                this.tokens.add(this.position - 2, smallestToken);
            }
        }

        protected InteriorNode split() {
            Pair<Long, InteriorNode> splitResult = this.splitBlock();
            Long middleValue = (Long)splitResult.left;
            InteriorNode sibling = (InteriorNode)splitResult.right;
            InteriorNode leftChild = null;
            if (this.parent == null) {
                this.parent = new InteriorNode();
                TokenTreeBuilder.this.root = this.parent;
                sibling.parent = this.parent;
                leftChild = this;
                TokenTreeBuilder.this.numBlocks++;
            }
            this.parent.add(middleValue, leftChild, sibling);
            return sibling;
        }

        protected Pair<Long, InteriorNode> splitBlock() {
            int i;
            int splitPosition = 246;
            InteriorNode sibling = new InteriorNode();
            sibling.parent = this.parent;
            this.next = sibling;
            Long middleValue = this.tokens.get(246);
            for (i = 246; i < 248; ++i) {
                if (i != 248 && i != 246) {
                    long token = this.tokens.get(i);
                    sibling.updateTokenRange(token);
                    sibling.tokens.add(token);
                }
                Node child = this.children.get(i + 1);
                child.parent = sibling;
                sibling.children.add(child);
                ++sibling.position;
            }
            for (i = 248; i >= 246; --i) {
                if (i != 248) {
                    this.tokens.remove(i);
                }
                if (i == 246) continue;
                this.children.remove(i);
            }
            this.nodeMinToken = this.smallestToken();
            this.nodeMaxToken = this.tokens.get(this.tokens.size() - 1);
            TokenTreeBuilder.this.numBlocks++;
            return Pair.create(middleValue, sibling);
        }

        protected boolean isFull() {
            return this.position >= 249;
        }

        private void serializeTokens(ByteBuffer buf) {
            for (Long token : this.tokens) {
                buf.putLong(token);
            }
        }

        private void serializeChildOffsets(long childBlockIndex, ByteBuffer buf) {
            for (int i = 0; i < this.children.size(); ++i) {
                buf.putLong((childBlockIndex + (long)i) * 4096L);
            }
        }
    }

    private class Leaf
    extends Node {
        private final SortedMap<Long, LongSet> tokens;
        private LongArrayList overflowCollisions;

        Leaf(SortedMap<Long, LongSet> data) {
            this.nodeMinToken = data.firstKey();
            this.nodeMaxToken = data.lastKey();
            this.tokens = data;
        }

        public Long largestToken() {
            return this.nodeMaxToken;
        }

        @Override
        public void serialize(long childBlockIndex, ByteBuffer buf) {
            this.serializeHeader(buf);
            this.serializeData(buf);
            this.serializeOverflowCollisions(buf);
        }

        @Override
        public int childCount() {
            return 0;
        }

        @Override
        public int tokenCount() {
            return this.tokens.size();
        }

        @Override
        public Long smallestToken() {
            return this.nodeMinToken;
        }

        public Iterator<Map.Entry<Long, LongSet>> tokenIterator() {
            return this.tokens.entrySet().iterator();
        }

        private void serializeData(ByteBuffer buf) {
            for (Map.Entry<Long, LongSet> entry : this.tokens.entrySet()) {
                this.createEntry(entry.getKey(), entry.getValue()).serialize(buf);
            }
        }

        private void serializeOverflowCollisions(ByteBuffer buf) {
            if (this.overflowCollisions != null) {
                for (LongCursor offset : this.overflowCollisions) {
                    buf.putLong(offset.value);
                }
            }
        }

        private LeafEntry createEntry(long tok, LongSet offsets) {
            int offsetCount = offsets.size();
            switch (offsetCount) {
                case 0: {
                    throw new AssertionError((Object)("no offsets for token " + tok));
                }
                case 1: {
                    long offset = offsets.toArray()[0];
                    if (offset > 0x7FFFFFFFFFFFL) {
                        throw new AssertionError((Object)("offset " + offset + " cannot be greater than " + 0x7FFFFFFFFFFFL));
                    }
                    if (offset <= Integer.MAX_VALUE) {
                        return new SimpleLeafEntry(tok, offset);
                    }
                    return new FactoredOffsetLeafEntry(tok, offset);
                }
                case 2: {
                    long[] rawOffsets = offsets.toArray();
                    if (rawOffsets[0] <= Integer.MAX_VALUE && rawOffsets[1] <= Integer.MAX_VALUE && (rawOffsets[0] <= 32767L || rawOffsets[1] <= 32767L)) {
                        return new PackedCollisionLeafEntry(tok, rawOffsets);
                    }
                    return this.createOverflowEntry(tok, offsetCount, offsets);
                }
            }
            return this.createOverflowEntry(tok, offsetCount, offsets);
        }

        private LeafEntry createOverflowEntry(long tok, int offsetCount, LongSet offsets) {
            if (this.overflowCollisions == null) {
                this.overflowCollisions = new LongArrayList();
            }
            OverflowCollisionLeafEntry entry = new OverflowCollisionLeafEntry(tok, (short)this.overflowCollisions.size(), (short)offsetCount);
            for (LongCursor o : offsets) {
                if (this.overflowCollisions.size() == 8) {
                    throw new AssertionError((Object)"cannot have more than 8 overflow collisions per leaf");
                }
                this.overflowCollisions.add(o.value);
            }
            return entry;
        }

        private class OverflowCollisionLeafEntry
        extends LeafEntry {
            private final short startIndex;
            private final short count;

            public OverflowCollisionLeafEntry(long tok, short collisionStartIndex, short collisionCount) {
                super(tok);
                this.startIndex = collisionStartIndex;
                this.count = collisionCount;
            }

            @Override
            public EntryType type() {
                return EntryType.OVERFLOW;
            }

            @Override
            public int offsetData() {
                return this.startIndex;
            }

            @Override
            public short offsetExtra() {
                return this.count;
            }
        }

        private class PackedCollisionLeafEntry
        extends LeafEntry {
            private short smallerOffset;
            private int largerOffset;

            public PackedCollisionLeafEntry(long tok, long[] offs) {
                super(tok);
                this.smallerOffset = (short)Math.min(offs[0], offs[1]);
                this.largerOffset = (int)Math.max(offs[0], offs[1]);
            }

            @Override
            public EntryType type() {
                return EntryType.PACKED;
            }

            @Override
            public int offsetData() {
                return this.largerOffset;
            }

            @Override
            public short offsetExtra() {
                return this.smallerOffset;
            }
        }

        private class FactoredOffsetLeafEntry
        extends LeafEntry {
            private final long offset;

            public FactoredOffsetLeafEntry(long tok, long off) {
                super(tok);
                this.offset = off;
            }

            @Override
            public EntryType type() {
                return EntryType.FACTORED;
            }

            @Override
            public int offsetData() {
                return (int)(this.offset >>> 16);
            }

            @Override
            public short offsetExtra() {
                return (short)this.offset;
            }
        }

        private class SimpleLeafEntry
        extends LeafEntry {
            private final long offset;

            public SimpleLeafEntry(long tok, long off) {
                super(tok);
                this.offset = off;
            }

            @Override
            public EntryType type() {
                return EntryType.SIMPLE;
            }

            @Override
            public int offsetData() {
                return (int)this.offset;
            }

            @Override
            public short offsetExtra() {
                return 0;
            }
        }

        private abstract class LeafEntry {
            protected final long token;

            public abstract EntryType type();

            public abstract int offsetData();

            public abstract short offsetExtra();

            public LeafEntry(long tok) {
                this.token = tok;
            }

            public void serialize(ByteBuffer buf) {
                buf.putShort((short)this.type().ordinal()).putShort(this.offsetExtra()).putLong(this.token).putInt(this.offsetData());
            }
        }
    }

    private abstract class Node {
        protected InteriorNode parent;
        protected Node next;
        protected Long nodeMinToken;
        protected Long nodeMaxToken;

        private Node() {
        }

        public abstract void serialize(long var1, ByteBuffer var3);

        public abstract int childCount();

        public abstract int tokenCount();

        public abstract Long smallestToken();

        public Iterator<Node> levelIterator() {
            return new LevelIterator(this);
        }

        public boolean isLeaf() {
            return this instanceof Leaf;
        }

        protected boolean isLastLeaf() {
            return this == TokenTreeBuilder.this.rightmostLeaf;
        }

        protected boolean isRoot() {
            return this == TokenTreeBuilder.this.root;
        }

        protected void updateTokenRange(long token) {
            this.nodeMinToken = this.nodeMinToken == null ? token : Math.min(this.nodeMinToken, token);
            this.nodeMaxToken = this.nodeMaxToken == null ? token : Math.max(this.nodeMaxToken, token);
        }

        protected void serializeHeader(ByteBuffer buf) {
            Header header = this.isRoot() ? new RootHeader() : (!this.isLeaf() ? new InteriorNodeHeader() : new LeafHeader());
            ((Header)header).serialize(buf);
            TokenTreeBuilder.alignBuffer(buf, 64);
        }

        private class LeafHeader
        extends Header {
            private LeafHeader() {
            }

            @Override
            protected byte infoByte() {
                byte infoByte = 1;
                infoByte = (byte)(infoByte | (Node.this.isLastLeaf() ? 2 : 0));
                return infoByte;
            }
        }

        private class InteriorNodeHeader
        extends Header {
            private InteriorNodeHeader() {
            }

            @Override
            protected byte infoByte() {
                return 0;
            }
        }

        private class RootHeader
        extends Header {
            private RootHeader() {
            }

            @Override
            public void serialize(ByteBuffer buf) {
                super.serialize(buf);
                this.writeMagic(buf);
                buf.putLong(TokenTreeBuilder.this.tokenCount).putLong(TokenTreeBuilder.this.treeMinToken).putLong(TokenTreeBuilder.this.treeMaxToken);
            }

            @Override
            protected byte infoByte() {
                return (byte)(Node.this.isLeaf() ? 3 : 0);
            }

            protected void writeMagic(ByteBuffer buf) {
                switch ("ab") {
                    case "ab": {
                        buf.putShort((short)23121);
                        break;
                    }
                }
            }
        }

        private abstract class Header {
            private Header() {
            }

            public void serialize(ByteBuffer buf) {
                buf.put(this.infoByte()).putShort((short)Node.this.tokenCount()).putLong(Node.this.nodeMinToken).putLong(Node.this.nodeMaxToken);
            }

            protected abstract byte infoByte();
        }
    }

    static enum EntryType {
        SIMPLE,
        FACTORED,
        PACKED,
        OVERFLOW;


        public static EntryType of(int ordinal) {
            if (ordinal == SIMPLE.ordinal()) {
                return SIMPLE;
            }
            if (ordinal == FACTORED.ordinal()) {
                return FACTORED;
            }
            if (ordinal == PACKED.ordinal()) {
                return PACKED;
            }
            if (ordinal == OVERFLOW.ordinal()) {
                return OVERFLOW;
            }
            throw new IllegalArgumentException("Unknown ordinal: " + ordinal);
        }
    }
}

