/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.io.util.FileUtils;

public class RangeIntersectionIterator {
    public static <K extends Comparable<K>, D extends CombinedValue<K>> Builder<K, D> builder() {
        return RangeIntersectionIterator.builder(Strategy.ADAPTIVE);
    }

    @VisibleForTesting
    protected static <K extends Comparable<K>, D extends CombinedValue<K>> Builder<K, D> builder(Strategy strategy) {
        return new Builder(strategy);
    }

    @VisibleForTesting
    protected static class LookupIntersectionIterator<K extends Comparable<K>, D extends CombinedValue<K>>
    extends AbstractIntersectionIterator<K, D> {
        private final RangeIterator<K, D> smallestIterator;

        private LookupIntersectionIterator(RangeIterator.Builder.Statistics<K, D> statistics, PriorityQueue<RangeIterator<K, D>> ranges) {
            super(statistics, ranges);
            this.smallestIterator = statistics.minRange;
            if (this.smallestIterator.getCurrent().compareTo(this.getMinimum()) < 0) {
                this.smallestIterator.skipTo(this.getMinimum());
            }
        }

        @Override
        protected D computeNext() {
            while (this.smallestIterator.hasNext()) {
                CombinedValue candidate = (CombinedValue)this.smallestIterator.next();
                Comparable token = (Comparable)candidate.get();
                boolean intersectsAll = true;
                for (RangeIterator range : this.ranges) {
                    if (range.equals(this.smallestIterator)) continue;
                    if (!LookupIntersectionIterator.isOverlapping(this.smallestIterator, range)) {
                        return (D)((CombinedValue)this.endOfData());
                    }
                    Object point = range.skipTo(token);
                    if (point == null) {
                        return (D)((CombinedValue)this.endOfData());
                    }
                    if (!((Comparable)point.get()).equals(token)) {
                        intersectsAll = false;
                        break;
                    }
                    candidate.merge(point);
                }
                if (!intersectsAll) continue;
                return (D)candidate;
            }
            return (D)((CombinedValue)this.endOfData());
        }

        @Override
        protected void performSkipTo(K nextToken) {
            this.smallestIterator.skipTo(nextToken);
        }
    }

    @VisibleForTesting
    protected static class BounceIntersectionIterator<K extends Comparable<K>, D extends CombinedValue<K>>
    extends AbstractIntersectionIterator<K, D> {
        private BounceIntersectionIterator(RangeIterator.Builder.Statistics<K, D> statistics, PriorityQueue<RangeIterator<K, D>> ranges) {
            super(statistics, ranges);
        }

        @Override
        protected D computeNext() {
            while (!this.ranges.isEmpty()) {
                CombinedValue candidate;
                RangeIterator head = (RangeIterator)this.ranges.poll();
                if (head.getCurrent().compareTo(this.getMinimum()) < 0) {
                    head.skipTo(this.getMinimum());
                }
                CombinedValue combinedValue = candidate = head.hasNext() ? (CombinedValue)head.next() : null;
                if (candidate == null || ((Comparable)candidate.get()).compareTo(this.getMaximum()) > 0) {
                    this.ranges.add(head);
                    return (D)((CombinedValue)this.endOfData());
                }
                ArrayList<RangeIterator> processed = new ArrayList<RangeIterator>();
                boolean intersectsAll = true;
                boolean exhausted = false;
                while (!this.ranges.isEmpty()) {
                    RangeIterator range = (RangeIterator)this.ranges.poll();
                    if (!BounceIntersectionIterator.isOverlapping(head, range)) {
                        exhausted = true;
                        intersectsAll = false;
                        break;
                    }
                    Object point = range.skipTo((Comparable)candidate.get());
                    if (point == null) {
                        exhausted = true;
                        intersectsAll = false;
                        break;
                    }
                    processed.add(range);
                    if (((Comparable)candidate.get()).equals(point.get())) {
                        candidate.merge(point);
                        Iterators.getNext((Iterator)((Object)range), null);
                        continue;
                    }
                    intersectsAll = false;
                    break;
                }
                this.ranges.add(head);
                for (RangeIterator range : processed) {
                    this.ranges.add(range);
                }
                if (exhausted) {
                    return (D)((CombinedValue)this.endOfData());
                }
                if (!intersectsAll) continue;
                return (D)candidate;
            }
            return (D)((CombinedValue)this.endOfData());
        }

        @Override
        protected void performSkipTo(K nextToken) {
            ArrayList<RangeIterator> skipped = new ArrayList<RangeIterator>();
            while (!this.ranges.isEmpty()) {
                RangeIterator range = (RangeIterator)this.ranges.poll();
                range.skipTo(nextToken);
                skipped.add(range);
            }
            for (RangeIterator range : skipped) {
                this.ranges.add(range);
            }
        }
    }

    private static abstract class AbstractIntersectionIterator<K extends Comparable<K>, D extends CombinedValue<K>>
    extends RangeIterator<K, D> {
        protected final PriorityQueue<RangeIterator<K, D>> ranges;

        private AbstractIntersectionIterator(RangeIterator.Builder.Statistics<K, D> statistics, PriorityQueue<RangeIterator<K, D>> ranges) {
            super(statistics);
            this.ranges = ranges;
        }

        @Override
        public void close() throws IOException {
            for (RangeIterator<K, D> range : this.ranges) {
                FileUtils.closeQuietly(range);
            }
        }
    }

    public static class Builder<K extends Comparable<K>, D extends CombinedValue<K>>
    extends RangeIterator.Builder<K, D> {
        private final Strategy strategy;

        public Builder(Strategy strategy) {
            super(RangeIterator.Builder.IteratorType.INTERSECTION);
            this.strategy = strategy;
        }

        @Override
        protected RangeIterator<K, D> buildIterator() {
            if (this.statistics.isDisjoint()) {
                return new BounceIntersectionIterator(this.statistics, new PriorityQueue(1));
            }
            switch (this.strategy) {
                case LOOKUP: {
                    return new LookupIntersectionIterator(this.statistics, this.ranges);
                }
                case BOUNCE: {
                    return new BounceIntersectionIterator(this.statistics, this.ranges);
                }
                case ADAPTIVE: {
                    return this.statistics.sizeRatio() <= 0.01 ? new LookupIntersectionIterator(this.statistics, this.ranges) : new BounceIntersectionIterator(this.statistics, this.ranges);
                }
            }
            throw new IllegalStateException("Unknown strategy: " + (Object)((Object)this.strategy));
        }
    }

    protected static enum Strategy {
        BOUNCE,
        LOOKUP,
        ADAPTIVE;

    }
}

