/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RowUpdateBuilder;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.SpeculativeRetryParam;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SchemaKeyspace.class);
    private static final boolean FLUSH_SCHEMA_TABLES = Boolean.valueOf(System.getProperty("cassandra.test.flush_local_schema_changes", "true"));
    public static final String NAME = "system_schema";
    public static final String KEYSPACES = "keyspaces";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";
    public static final String DROPPED_COLUMNS = "dropped_columns";
    public static final String TRIGGERS = "triggers";
    public static final String VIEWS = "views";
    public static final String TYPES = "types";
    public static final String FUNCTIONS = "functions";
    public static final String AGGREGATES = "aggregates";
    public static final String INDEXES = "indexes";
    public static final List<String> ALL = ImmutableList.of((Object)"keyspaces", (Object)"tables", (Object)"columns", (Object)"dropped_columns", (Object)"triggers", (Object)"views", (Object)"types", (Object)"functions", (Object)"aggregates", (Object)"indexes");
    private static final CFMetaData Keyspaces = SchemaKeyspace.compile("keyspaces", "keyspace definitions", "CREATE TABLE %s (keyspace_name text,durable_writes boolean,replication frozen<map<text, text>>,PRIMARY KEY ((keyspace_name)))");
    private static final CFMetaData Tables = SchemaKeyspace.compile("tables", "table definitions", "CREATE TABLE %s (keyspace_name text,table_name text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,crc_check_chance double,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,flags frozen<set<text>>,gc_grace_seconds int,id uuid,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,PRIMARY KEY ((keyspace_name), table_name))");
    private static final CFMetaData Columns = SchemaKeyspace.compile("columns", "column definitions", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,clustering_order text,column_name_bytes blob,kind text,position int,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final CFMetaData DroppedColumns = SchemaKeyspace.compile("dropped_columns", "dropped column registry", "CREATE TABLE %s (keyspace_name text,table_name text,column_name text,dropped_time timestamp,type text,PRIMARY KEY ((keyspace_name), table_name, column_name))");
    private static final CFMetaData Triggers = SchemaKeyspace.compile("triggers", "trigger definitions", "CREATE TABLE %s (keyspace_name text,table_name text,trigger_name text,options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, trigger_name))");
    private static final CFMetaData Views = SchemaKeyspace.compile("views", "view definitions", "CREATE TABLE %s (keyspace_name text,view_name text,base_table_id uuid,base_table_name text,where_clause text,bloom_filter_fp_chance double,caching frozen<map<text, text>>,comment text,compaction frozen<map<text, text>>,compression frozen<map<text, text>>,crc_check_chance double,dclocal_read_repair_chance double,default_time_to_live int,extensions frozen<map<text, blob>>,gc_grace_seconds int,id uuid,include_all_columns boolean,max_index_interval int,memtable_flush_period_in_ms int,min_index_interval int,read_repair_chance double,speculative_retry text,PRIMARY KEY ((keyspace_name), view_name))");
    private static final CFMetaData Indexes = SchemaKeyspace.compile("indexes", "secondary index definitions", "CREATE TABLE %s (keyspace_name text,table_name text,index_name text,kind text,options frozen<map<text, text>>,PRIMARY KEY ((keyspace_name), table_name, index_name))");
    private static final CFMetaData Types = SchemaKeyspace.compile("types", "user defined type definitions", "CREATE TABLE %s (keyspace_name text,type_name text,field_names frozen<list<text>>,field_types frozen<list<text>>,PRIMARY KEY ((keyspace_name), type_name))");
    private static final CFMetaData Functions = SchemaKeyspace.compile("functions", "user defined function definitions", "CREATE TABLE %s (keyspace_name text,function_name text,argument_types frozen<list<text>>,argument_names frozen<list<text>>,body text,language text,return_type text,called_on_null_input boolean,PRIMARY KEY ((keyspace_name), function_name, argument_types))");
    private static final CFMetaData Aggregates = SchemaKeyspace.compile("aggregates", "user defined aggregate definitions", "CREATE TABLE %s (keyspace_name text,aggregate_name text,argument_types frozen<list<text>>,final_func text,initcond text,return_type text,state_func text,state_type text,PRIMARY KEY ((keyspace_name), aggregate_name, argument_types))");
    public static final List<CFMetaData> ALL_TABLE_METADATA = ImmutableList.of((Object)Keyspaces, (Object)Tables, (Object)Columns, (Object)Triggers, (Object)DroppedColumns, (Object)Views, (Object)Types, (Object)Functions, (Object)Aggregates, (Object)Indexes);

    private SchemaKeyspace() {
    }

    private static CFMetaData compile(String name, String description, String schema) {
        return CFMetaData.compile(String.format(schema, name), NAME).comment(description).gcGraceSeconds((int)TimeUnit.DAYS.toSeconds(7L));
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create(NAME, KeyspaceParams.local(), org.apache.cassandra.schema.Tables.of(ALL_TABLE_METADATA));
    }

    public static void saveSystemKeyspacesSchema() {
        KeyspaceMetadata system = Schema.instance.getKSMetaData("system");
        KeyspaceMetadata schema = Schema.instance.getKSMetaData(NAME);
        long timestamp = FBUtilities.timestampMicros();
        for (String schemaTable : ALL) {
            String query = String.format("DELETE FROM %s.%s USING TIMESTAMP ? WHERE keyspace_name = ?", NAME, schemaTable);
            for (String systemKeyspace : Schema.SYSTEM_KEYSPACE_NAMES) {
                QueryProcessor.executeOnceInternal(query, timestamp, systemKeyspace);
            }
        }
        SchemaKeyspace.makeCreateKeyspaceMutation(system, timestamp + 1L).apply();
        SchemaKeyspace.makeCreateKeyspaceMutation(schema, timestamp + 1L).apply();
    }

    public static void truncate() {
        ALL.forEach(table -> SchemaKeyspace.getSchemaCFS(table).truncateBlocking());
    }

    static void flush() {
        if (!Boolean.getBoolean("cassandra.unsafesystem")) {
            ALL.forEach(table -> FBUtilities.waitOnFuture(SchemaKeyspace.getSchemaCFS(table).forceFlush()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UUID calculateSchemaDigest() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Iterator<String> iterator = ALL.iterator();
        block28: while (iterator.hasNext()) {
            String table = iterator.next();
            if (table.equals(DROPPED_COLUMNS)) continue;
            ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(table);
            ReadExecutionController executionController = cmd.executionController();
            Throwable throwable = null;
            try {
                PartitionIterator schema = cmd.executeInternal(executionController);
                Throwable throwable2 = null;
                try {
                    while (true) {
                        RowIterator partition;
                        block34: {
                            if (!schema.hasNext()) continue block28;
                            partition = (RowIterator)schema.next();
                            Throwable throwable3 = null;
                            try {
                                if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) {
                                    RowIterators.digest(partition, digest);
                                }
                                if (partition == null) continue;
                                if (throwable3 == null) break block34;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (partition == null) throw throwable5;
                                    if (throwable3 != null) {
                                        try {
                                            partition.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                    partition.close();
                                    throw throwable5;
                                }
                            }
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        partition.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (schema == null) continue;
                    if (throwable2 != null) {
                        try {
                            schema.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    schema.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (executionController == null) continue;
                if (throwable != null) {
                    try {
                        executionController.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                executionController.close();
            }
        }
        return UUID.nameUUIDFromBytes(digest.digest());
    }

    private static ColumnFamilyStore getSchemaCFS(String schemaTableName) {
        return Keyspace.open(NAME).getColumnFamilyStore(schemaTableName);
    }

    private static ReadCommand getReadCommandForTableSchema(String schemaTableName) {
        ColumnFamilyStore cfs = SchemaKeyspace.getSchemaCFS(schemaTableName);
        return PartitionRangeReadCommand.allDataRead(cfs.metadata, FBUtilities.nowInSeconds());
    }

    public static Collection<Mutation> convertSchemaToMutations() {
        HashMap<DecoratedKey, Mutation> mutationMap = new HashMap<DecoratedKey, Mutation>();
        for (String table : ALL) {
            SchemaKeyspace.convertSchemaToMutations(mutationMap, table);
        }
        return mutationMap.values();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void convertSchemaToMutations(Map<DecoratedKey, Mutation> mutationMap, String schemaTableName) {
        ReadCommand cmd = SchemaKeyspace.getReadCommandForTableSchema(schemaTableName);
        try (ReadExecutionController executionController = cmd.executionController();
             UnfilteredPartitionIterator iter = cmd.executeLocally(executionController);){
            Throwable throwable;
            UnfilteredRowIterator partition;
            while (iter.hasNext()) {
                block40: {
                    block38: {
                        block39: {
                            partition = (UnfilteredRowIterator)iter.next();
                            throwable = null;
                            if (!SchemaKeyspace.isSystemKeyspaceSchemaPartition(partition.partitionKey())) break block38;
                            if (partition == null) continue;
                            if (throwable == null) break block39;
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        partition.close();
                        continue;
                    }
                    DecoratedKey key = partition.partitionKey();
                    Mutation mutation = mutationMap.get(key);
                    if (mutation == null) {
                        mutation = new Mutation(NAME, key);
                        mutationMap.put(key, mutation);
                    }
                    mutation.add(PartitionUpdate.fromIterator(partition, cmd.columnFilter()));
                    if (partition == null) continue;
                    if (throwable == null) break block40;
                    try {
                        partition.close();
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        continue;
                    }
                }
                partition.close();
            }
            return;
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (partition == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            partition.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    partition.close();
                    throw throwable5;
                }
            }
        }
    }

    private static ByteBuffer getSchemaKSKey(String ksName) {
        return AsciiType.instance.fromString(ksName);
    }

    private static boolean isSystemKeyspaceSchemaPartition(DecoratedKey partitionKey) {
        return Schema.isSystemKeyspace((String)UTF8Type.instance.compose(partitionKey.getKey()));
    }

    public static Mutation makeCreateKeyspaceMutation(String name, KeyspaceParams params, long timestamp) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Keyspaces, timestamp, name).clustering(new Object[0]);
        return adder.add(KeyspaceParams.Option.DURABLE_WRITES.toString(), (Object)params.durableWrites).frozenMap(KeyspaceParams.Option.REPLICATION.toString(), params.replication.asMap()).build();
    }

    public static Mutation makeCreateKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        keyspace.tables.forEach(table -> SchemaKeyspace.addTableToSchemaMutation(table, timestamp, true, mutation));
        keyspace.views.forEach(view -> SchemaKeyspace.addViewToSchemaMutation(view, timestamp, true, mutation));
        keyspace.types.forEach(type -> SchemaKeyspace.addTypeToSchemaMutation(type, timestamp, mutation));
        keyspace.functions.udfs().forEach(udf -> SchemaKeyspace.addFunctionToSchemaMutation(udf, timestamp, mutation));
        keyspace.functions.udas().forEach(uda -> SchemaKeyspace.addAggregateToSchemaMutation(uda, timestamp, mutation));
        return mutation;
    }

    public static Mutation makeDropKeyspaceMutation(KeyspaceMetadata keyspace, long timestamp) {
        int nowInSec = FBUtilities.nowInSeconds();
        Mutation mutation = new Mutation(NAME, Keyspaces.decorateKey(SchemaKeyspace.getSchemaKSKey(keyspace.name)));
        for (CFMetaData schemaTable : ALL_TABLE_METADATA) {
            mutation.add(PartitionUpdate.fullPartitionDelete(schemaTable, mutation.key(), timestamp, nowInSec));
        }
        return mutation;
    }

    public static Mutation makeCreateTypeMutation(KeyspaceMetadata keyspace, UserType type, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTypeToSchemaMutation(type, timestamp, mutation);
        return mutation;
    }

    static void addTypeToSchemaMutation(UserType type, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Types, timestamp, mutation).clustering(type.getNameAsString()).frozenList("field_names", type.fieldNames().stream().map(SchemaKeyspace::bbToString).collect(Collectors.toList())).frozenList("field_types", type.fieldTypes().stream().map(AbstractType::asCQL3Type).map(Object::toString).collect(Collectors.toList()));
        adder.build();
    }

    private static String bbToString(ByteBuffer bb) {
        try {
            return ByteBufferUtil.string(bb);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Mutation dropTypeFromSchemaMutation(KeyspaceMetadata keyspace, UserType type, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        return RowUpdateBuilder.deleteRow(Types, timestamp, mutation, type.name);
    }

    public static Mutation makeCreateTableMutation(KeyspaceMetadata keyspace, CFMetaData table, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(table, timestamp, true, mutation);
        return mutation;
    }

    static void addTableToSchemaMutation(CFMetaData table, long timestamp, boolean withColumnsAndTriggers, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Tables, timestamp, mutation).clustering(table.cfName);
        SchemaKeyspace.addTableParamsToSchemaMutation(table.params, adder);
        adder.add("id", (Object)table.cfId).frozenSet("flags", CFMetaData.flagsToStrings(table.flags())).build();
        if (withColumnsAndTriggers) {
            for (ColumnDefinition columnDefinition : table.allColumns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, columnDefinition, timestamp, mutation);
            }
            for (CFMetaData.DroppedColumn droppedColumn : table.getDroppedColumns().values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, droppedColumn, timestamp, mutation);
            }
            for (TriggerMetadata triggerMetadata : table.getTriggers()) {
                SchemaKeyspace.addTriggerToSchemaMutation(table, triggerMetadata, timestamp, mutation);
            }
            for (IndexMetadata indexMetadata : table.getIndexes()) {
                SchemaKeyspace.addIndexToSchemaMutation(table, indexMetadata, timestamp, mutation);
            }
        }
    }

    private static void addTableParamsToSchemaMutation(TableParams params, RowUpdateBuilder adder) {
        adder.add("bloom_filter_fp_chance", (Object)params.bloomFilterFpChance).add("comment", (Object)params.comment).add("dclocal_read_repair_chance", (Object)params.dcLocalReadRepairChance).add("default_time_to_live", (Object)params.defaultTimeToLive).add("gc_grace_seconds", (Object)params.gcGraceSeconds).add("max_index_interval", (Object)params.maxIndexInterval).add("memtable_flush_period_in_ms", (Object)params.memtableFlushPeriodInMs).add("min_index_interval", (Object)params.minIndexInterval).add("read_repair_chance", (Object)params.readRepairChance).add("speculative_retry", (Object)params.speculativeRetry.toString()).add("crc_check_chance", (Object)params.crcCheckChance).frozenMap("caching", params.caching.asMap()).frozenMap("compaction", params.compaction.asMap()).frozenMap("compression", params.compression.asMap()).frozenMap("extensions", (Map<?, ?>)params.extensions);
    }

    public static Mutation makeUpdateTableMutation(KeyspaceMetadata keyspace, CFMetaData oldTable, CFMetaData newTable, long timestamp, boolean fromThrift) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addTableToSchemaMutation(newTable, timestamp, false, mutation);
        MapDifference columnDiff = Maps.difference(oldTable.getColumnMetadata(), newTable.getColumnMetadata());
        for (ColumnDefinition column : columnDiff.entriesOnlyOnLeft().values()) {
            if (fromThrift && column.kind != ColumnDefinition.Kind.REGULAR && (!newTable.isStaticCompactTable() || column.kind != ColumnDefinition.Kind.STATIC)) continue;
            SchemaKeyspace.dropColumnFromSchemaMutation(oldTable, column, timestamp, mutation);
        }
        for (ColumnDefinition column : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, column, timestamp, mutation);
        }
        for (Iterator name : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(newTable, newTable.getColumnDefinition((ByteBuffer)((Object)name)), timestamp, mutation);
        }
        MapDifference droppedColumnDiff = Maps.difference(oldTable.getDroppedColumns(), newTable.getDroppedColumns());
        for (CFMetaData.DroppedColumn column : droppedColumnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, column, timestamp, mutation);
        }
        for (Iterator name : droppedColumnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newTable, newTable.getDroppedColumns().get(name), timestamp, mutation);
        }
        MapDifference<String, TriggerMetadata> triggerDiff = SchemaKeyspace.triggersDiff(oldTable.getTriggers(), newTable.getTriggers());
        for (TriggerMetadata trigger : triggerDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(oldTable, trigger, timestamp, mutation);
        }
        for (TriggerMetadata trigger : triggerDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addTriggerToSchemaMutation(newTable, trigger, timestamp, mutation);
        }
        MapDifference<String, IndexMetadata> indexesDiff = SchemaKeyspace.indexesDiff(oldTable.getIndexes(), newTable.getIndexes());
        for (IndexMetadata index : indexesDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(oldTable, index, timestamp, mutation);
        }
        for (IndexMetadata index : indexesDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addIndexToSchemaMutation(newTable, index, timestamp, mutation);
        }
        for (MapDifference.ValueDifference diff : indexesDiff.entriesDiffering().values()) {
            SchemaKeyspace.addUpdatedIndexToSchemaMutation(newTable, (IndexMetadata)diff.rightValue(), timestamp, mutation);
        }
        return mutation;
    }

    private static MapDifference<String, IndexMetadata> indexesDiff(Indexes before, Indexes after) {
        HashMap beforeMap = new HashMap();
        before.forEach(i -> beforeMap.put(i.name, i));
        HashMap afterMap = new HashMap();
        after.forEach(i -> afterMap.put(i.name, i));
        return Maps.difference(beforeMap, afterMap);
    }

    private static MapDifference<String, TriggerMetadata> triggersDiff(Triggers before, Triggers after) {
        HashMap beforeMap = new HashMap();
        before.forEach(t -> beforeMap.put(t.name, t));
        HashMap afterMap = new HashMap();
        after.forEach(t -> afterMap.put(t.name, t));
        return Maps.difference(beforeMap, afterMap);
    }

    public static Mutation makeDropTableMutation(KeyspaceMetadata keyspace, CFMetaData table, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        RowUpdateBuilder.deleteRow(Tables, timestamp, mutation, table.cfName);
        for (ColumnDefinition column : table.allColumns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, column, timestamp, mutation);
        }
        for (TriggerMetadata trigger : table.getTriggers()) {
            SchemaKeyspace.dropTriggerFromSchemaMutation(table, trigger, timestamp, mutation);
        }
        for (IndexMetadata index : table.getIndexes()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(table, index, timestamp, mutation);
        }
        return mutation;
    }

    private static void addColumnToSchemaMutation(CFMetaData table, ColumnDefinition column, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Columns, timestamp, mutation).clustering(table.cfName, column.name.toString());
        AbstractType type = column.type;
        if (type instanceof ReversedType) {
            type = ((ReversedType)type).baseType;
        }
        adder.add("column_name_bytes", (Object)column.name.bytes).add("kind", (Object)column.kind.toString().toLowerCase()).add("position", (Object)column.position()).add("clustering_order", (Object)column.clusteringOrder().toString().toLowerCase()).add("type", (Object)type.asCQL3Type().toString()).build();
    }

    private static void dropColumnFromSchemaMutation(CFMetaData table, ColumnDefinition column, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(Columns, timestamp, mutation, table.cfName, column.name.toString());
    }

    private static void addDroppedColumnToSchemaMutation(CFMetaData table, CFMetaData.DroppedColumn column, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(DroppedColumns, timestamp, mutation).clustering(table.cfName, column.name);
        adder.add("dropped_time", (Object)new Date(TimeUnit.MICROSECONDS.toMillis(column.droppedTime))).add("type", (Object)SchemaKeyspace.expandUserTypes(column.type).asCQL3Type().toString()).build();
    }

    private static void addTriggerToSchemaMutation(CFMetaData table, TriggerMetadata trigger, long timestamp, Mutation mutation) {
        new RowUpdateBuilder(Triggers, timestamp, mutation).clustering(table.cfName, trigger.name).frozenMap("options", Collections.singletonMap("class", trigger.classOption)).build();
    }

    private static void dropTriggerFromSchemaMutation(CFMetaData table, TriggerMetadata trigger, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(Triggers, timestamp, mutation, table.cfName, trigger.name);
    }

    public static Mutation makeCreateViewMutation(KeyspaceMetadata keyspace, ViewDefinition view, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addViewToSchemaMutation(view, timestamp, true, mutation);
        return mutation;
    }

    private static void addViewToSchemaMutation(ViewDefinition view, long timestamp, boolean includeColumns, Mutation mutation) {
        RowUpdateBuilder builder = new RowUpdateBuilder(Views, timestamp, mutation).clustering(view.viewName);
        CFMetaData table = view.metadata;
        builder.add("include_all_columns", (Object)view.includeAllColumns).add("base_table_id", (Object)view.baseTableId).add("base_table_name", (Object)view.baseTableMetadata().cfName).add("where_clause", (Object)view.whereClause).add("id", (Object)table.cfId);
        SchemaKeyspace.addTableParamsToSchemaMutation(table.params, builder);
        if (includeColumns) {
            for (ColumnDefinition columnDefinition : table.allColumns()) {
                SchemaKeyspace.addColumnToSchemaMutation(table, columnDefinition, timestamp, mutation);
            }
            for (CFMetaData.DroppedColumn droppedColumn : table.getDroppedColumns().values()) {
                SchemaKeyspace.addDroppedColumnToSchemaMutation(table, droppedColumn, timestamp, mutation);
            }
        }
        builder.build();
    }

    public static Mutation makeDropViewMutation(KeyspaceMetadata keyspace, ViewDefinition view, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        RowUpdateBuilder.deleteRow(Views, timestamp, mutation, view.viewName);
        CFMetaData table = view.metadata;
        for (ColumnDefinition column : table.allColumns()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(table, column, timestamp, mutation);
        }
        for (IndexMetadata index : table.getIndexes()) {
            SchemaKeyspace.dropIndexFromSchemaMutation(table, index, timestamp, mutation);
        }
        return mutation;
    }

    public static Mutation makeUpdateViewMutation(KeyspaceMetadata keyspace, ViewDefinition oldView, ViewDefinition newView, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addViewToSchemaMutation(newView, timestamp, false, mutation);
        MapDifference columnDiff = Maps.difference(oldView.metadata.getColumnMetadata(), newView.metadata.getColumnMetadata());
        for (ColumnDefinition column : columnDiff.entriesOnlyOnLeft().values()) {
            SchemaKeyspace.dropColumnFromSchemaMutation(oldView.metadata, column, timestamp, mutation);
        }
        for (ColumnDefinition column : columnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addColumnToSchemaMutation(newView.metadata, column, timestamp, mutation);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addColumnToSchemaMutation(newView.metadata, newView.metadata.getColumnDefinition(name), timestamp, mutation);
        }
        MapDifference droppedColumnDiff = Maps.difference(oldView.metadata.getDroppedColumns(), oldView.metadata.getDroppedColumns());
        for (CFMetaData.DroppedColumn column : droppedColumnDiff.entriesOnlyOnRight().values()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(oldView.metadata, column, timestamp, mutation);
        }
        for (ByteBuffer name : droppedColumnDiff.entriesDiffering().keySet()) {
            SchemaKeyspace.addDroppedColumnToSchemaMutation(newView.metadata, newView.metadata.getDroppedColumns().get(name), timestamp, mutation);
        }
        return mutation;
    }

    private static void addIndexToSchemaMutation(CFMetaData table, IndexMetadata index, long timestamp, Mutation mutation) {
        RowUpdateBuilder builder = new RowUpdateBuilder(Indexes, timestamp, mutation).clustering(table.cfName, index.name);
        builder.add("kind", (Object)index.kind.toString());
        builder.frozenMap("options", index.options);
        builder.build();
    }

    private static void dropIndexFromSchemaMutation(CFMetaData table, IndexMetadata index, long timestamp, Mutation mutation) {
        RowUpdateBuilder.deleteRow(Indexes, timestamp, mutation, table.cfName, index.name);
    }

    private static void addUpdatedIndexToSchemaMutation(CFMetaData table, IndexMetadata index, long timestamp, Mutation mutation) {
        SchemaKeyspace.addIndexToSchemaMutation(table, index, timestamp, mutation);
    }

    public static Mutation makeCreateFunctionMutation(KeyspaceMetadata keyspace, UDFunction function, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addFunctionToSchemaMutation(function, timestamp, mutation);
        return mutation;
    }

    static void addFunctionToSchemaMutation(UDFunction function, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Functions, timestamp, mutation).clustering(function.name().name, SchemaKeyspace.functionArgumentsList(function));
        adder.add("body", (Object)function.body()).add("language", (Object)function.language()).add("return_type", (Object)function.returnType().asCQL3Type().toString()).add("called_on_null_input", (Object)function.isCalledOnNullInput()).frozenList("argument_names", function.argNames().stream().map(c -> SchemaKeyspace.bbToString(c.bytes)).collect(Collectors.toList()));
        adder.build();
    }

    private static List<String> functionArgumentsList(AbstractFunction fun) {
        return fun.argTypes().stream().map(AbstractType::asCQL3Type).map(Object::toString).collect(Collectors.toList());
    }

    public static Mutation makeDropFunctionMutation(KeyspaceMetadata keyspace, UDFunction function, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        return RowUpdateBuilder.deleteRow(Functions, timestamp, mutation, function.name().name, SchemaKeyspace.functionArgumentsList(function));
    }

    public static Mutation makeCreateAggregateMutation(KeyspaceMetadata keyspace, UDAggregate aggregate, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        SchemaKeyspace.addAggregateToSchemaMutation(aggregate, timestamp, mutation);
        return mutation;
    }

    static void addAggregateToSchemaMutation(UDAggregate aggregate, long timestamp, Mutation mutation) {
        RowUpdateBuilder adder = new RowUpdateBuilder(Aggregates, timestamp, mutation).clustering(aggregate.name().name, SchemaKeyspace.functionArgumentsList(aggregate));
        adder.add("return_type", (Object)aggregate.returnType().asCQL3Type().toString()).add("state_func", (Object)aggregate.stateFunction().name().name).add("state_type", (Object)aggregate.stateType().asCQL3Type().toString()).add("final_func", aggregate.finalFunction() != null ? aggregate.finalFunction().name().name : null).add("initcond", aggregate.initialCondition() != null ? aggregate.stateType().freeze().asCQL3Type().toCQLLiteral(aggregate.initialCondition(), 4) : null).build();
    }

    public static Mutation makeDropAggregateMutation(KeyspaceMetadata keyspace, UDAggregate aggregate, long timestamp) {
        Mutation mutation = SchemaKeyspace.makeCreateKeyspaceMutation(keyspace.name, keyspace.params, timestamp);
        return RowUpdateBuilder.deleteRow(Aggregates, timestamp, mutation, aggregate.name().name, SchemaKeyspace.functionArgumentsList(aggregate));
    }

    public static Keyspaces fetchNonSystemKeyspaces() {
        return SchemaKeyspace.fetchKeyspacesWithout(Schema.SYSTEM_KEYSPACE_NAMES);
    }

    private static Keyspaces fetchKeyspacesWithout(Set<String> excludedKeyspaceNames) {
        String query = String.format("SELECT keyspace_name FROM %s.%s", NAME, KEYSPACES);
        Keyspaces.Builder keyspaces = org.apache.cassandra.schema.Keyspaces.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, new Object[0])) {
            String keyspaceName = row.getString("keyspace_name");
            if (excludedKeyspaceNames.contains(keyspaceName)) continue;
            keyspaces.add(SchemaKeyspace.fetchKeyspace(keyspaceName));
        }
        return keyspaces.build();
    }

    private static Keyspaces fetchKeyspacesOnly(Set<String> includedKeyspaceNames) {
        String query = String.format("SELECT keyspace_name FROM %s.%s WHERE keyspace_name IN ?", NAME, KEYSPACES);
        Keyspaces.Builder keyspaces = org.apache.cassandra.schema.Keyspaces.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, new ArrayList<String>(includedKeyspaceNames))) {
            keyspaces.add(SchemaKeyspace.fetchKeyspace(row.getString("keyspace_name")));
        }
        return keyspaces.build();
    }

    private static KeyspaceMetadata fetchKeyspace(String keyspaceName) {
        KeyspaceParams params = SchemaKeyspace.fetchKeyspaceParams(keyspaceName);
        Types types = SchemaKeyspace.fetchTypes(keyspaceName);
        Tables tables = SchemaKeyspace.fetchTables(keyspaceName, types);
        Views views = SchemaKeyspace.fetchViews(keyspaceName, types);
        Functions functions = SchemaKeyspace.fetchFunctions(keyspaceName, types);
        return KeyspaceMetadata.create(keyspaceName, params, tables, views, types, functions);
    }

    private static KeyspaceParams fetchKeyspaceParams(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", NAME, KEYSPACES);
        UntypedResultSet.Row row = SchemaKeyspace.query(query, keyspaceName).one();
        boolean durableWrites = row.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString());
        Map<String, String> replication = row.getFrozenTextMap(KeyspaceParams.Option.REPLICATION.toString());
        return KeyspaceParams.create(durableWrites, replication);
    }

    private static Types fetchTypes(String keyspaceName) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", NAME, TYPES);
        Types.RawBuilder types = org.apache.cassandra.schema.Types.rawBuilder(keyspaceName);
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            String name = row.getString("type_name");
            List<String> fieldNames = row.getFrozenList("field_names", UTF8Type.instance);
            List<String> fieldTypes = row.getFrozenList("field_types", UTF8Type.instance);
            types.add(name, fieldNames, fieldTypes);
        }
        return types.build();
    }

    private static Tables fetchTables(String keyspaceName, Types types) {
        String query = String.format("SELECT table_name FROM %s.%s WHERE keyspace_name = ?", NAME, TABLES);
        Tables.Builder tables = org.apache.cassandra.schema.Tables.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            tables.add(SchemaKeyspace.fetchTable(keyspaceName, row.getString("table_name"), types));
        }
        return tables.build();
    }

    private static CFMetaData fetchTable(String keyspaceName, String tableName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", NAME, TABLES);
        UntypedResultSet rows = SchemaKeyspace.query(query, keyspaceName, tableName);
        if (rows.isEmpty()) {
            throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspaceName, tableName));
        }
        UntypedResultSet.Row row = rows.one();
        UUID id = row.getUUID("id");
        Set<CFMetaData.Flag> flags = CFMetaData.flagsFromStrings(row.getFrozenSet("flags", UTF8Type.instance));
        boolean isSuper = flags.contains((Object)CFMetaData.Flag.SUPER);
        boolean isCounter = flags.contains((Object)CFMetaData.Flag.COUNTER);
        boolean isDense = flags.contains((Object)CFMetaData.Flag.DENSE);
        boolean isCompound = flags.contains((Object)CFMetaData.Flag.COMPOUND);
        List<ColumnDefinition> columns = SchemaKeyspace.fetchColumns(keyspaceName, tableName, types);
        Map<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns = SchemaKeyspace.fetchDroppedColumns(keyspaceName, tableName);
        Indexes indexes = SchemaKeyspace.fetchIndexes(keyspaceName, tableName);
        Triggers triggers = SchemaKeyspace.fetchTriggers(keyspaceName, tableName);
        return CFMetaData.create(keyspaceName, tableName, id, isDense, isCompound, isSuper, isCounter, false, columns, DatabaseDescriptor.getPartitioner()).params(SchemaKeyspace.createTableParamsFromRow(row)).droppedColumns(droppedColumns).indexes(indexes).triggers(triggers);
    }

    public static TableParams createTableParamsFromRow(UntypedResultSet.Row row) {
        return TableParams.builder().bloomFilterFpChance(row.getDouble("bloom_filter_fp_chance")).caching(CachingParams.fromMap(row.getFrozenTextMap("caching"))).comment(row.getString("comment")).compaction(CompactionParams.fromMap(row.getFrozenTextMap("compaction"))).compression(CompressionParams.fromMap(row.getFrozenTextMap("compression"))).dcLocalReadRepairChance(row.getDouble("dclocal_read_repair_chance")).defaultTimeToLive(row.getInt("default_time_to_live")).extensions(row.getFrozenMap("extensions", UTF8Type.instance, BytesType.instance)).gcGraceSeconds(row.getInt("gc_grace_seconds")).maxIndexInterval(row.getInt("max_index_interval")).memtableFlushPeriodInMs(row.getInt("memtable_flush_period_in_ms")).minIndexInterval(row.getInt("min_index_interval")).readRepairChance(row.getDouble("read_repair_chance")).crcCheckChance(row.getDouble("crc_check_chance")).speculativeRetry(SpeculativeRetryParam.fromString(row.getString("speculative_retry"))).build();
    }

    private static List<ColumnDefinition> fetchColumns(String keyspace, String table, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", NAME, COLUMNS);
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> columns.add(SchemaKeyspace.createColumnFromRow(row, types)));
        return columns;
    }

    public static ColumnDefinition createColumnFromRow(UntypedResultSet.Row row, Types types) {
        String keyspace = row.getString("keyspace_name");
        String table = row.getString("table_name");
        ColumnIdentifier name = ColumnIdentifier.getInterned(row.getBytes("column_name_bytes"), row.getString("column_name"));
        ColumnDefinition.Kind kind = ColumnDefinition.Kind.valueOf(row.getString("kind").toUpperCase());
        int position = row.getInt("position");
        ColumnDefinition.ClusteringOrder order = ColumnDefinition.ClusteringOrder.valueOf(row.getString("clustering_order").toUpperCase());
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), types);
        if (order == ColumnDefinition.ClusteringOrder.DESC) {
            type = ReversedType.getInstance(type);
        }
        return new ColumnDefinition(keyspace, table, name, type, position, kind);
    }

    private static Map<ByteBuffer, CFMetaData.DroppedColumn> fetchDroppedColumns(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", NAME, DROPPED_COLUMNS);
        HashMap<ByteBuffer, CFMetaData.DroppedColumn> columns = new HashMap<ByteBuffer, CFMetaData.DroppedColumn>();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspace, table)) {
            CFMetaData.DroppedColumn column = SchemaKeyspace.createDroppedColumnFromRow(row);
            columns.put(UTF8Type.instance.decompose(column.name), column);
        }
        return columns;
    }

    private static CFMetaData.DroppedColumn createDroppedColumnFromRow(UntypedResultSet.Row row) {
        String keyspace = row.getString("keyspace_name");
        String name = row.getString("column_name");
        AbstractType<?> type = CQLTypeParser.parse(keyspace, row.getString("type"), org.apache.cassandra.schema.Types.none());
        long droppedTime = TimeUnit.MILLISECONDS.toMicros(row.getLong("dropped_time"));
        return new CFMetaData.DroppedColumn(name, type, droppedTime);
    }

    private static Indexes fetchIndexes(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", NAME, INDEXES);
        Indexes.Builder indexes = org.apache.cassandra.schema.Indexes.builder();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> indexes.add(SchemaKeyspace.createIndexMetadataFromRow(row)));
        return indexes.build();
    }

    private static IndexMetadata createIndexMetadataFromRow(UntypedResultSet.Row row) {
        String name = row.getString("index_name");
        IndexMetadata.Kind type = IndexMetadata.Kind.valueOf(row.getString("kind"));
        Map<String, String> options = row.getFrozenTextMap("options");
        return IndexMetadata.fromSchemaMetadata(name, type, options);
    }

    private static Triggers fetchTriggers(String keyspace, String table) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", NAME, TRIGGERS);
        Triggers.Builder triggers = org.apache.cassandra.schema.Triggers.builder();
        SchemaKeyspace.query(query, keyspace, table).forEach(row -> triggers.add(SchemaKeyspace.createTriggerFromRow(row)));
        return triggers.build();
    }

    private static TriggerMetadata createTriggerFromRow(UntypedResultSet.Row row) {
        String name = row.getString("trigger_name");
        String classOption = row.getFrozenTextMap("options").get("class");
        return new TriggerMetadata(name, classOption);
    }

    private static Views fetchViews(String keyspaceName, Types types) {
        String query = String.format("SELECT view_name FROM %s.%s WHERE keyspace_name = ?", NAME, VIEWS);
        Views.Builder views = org.apache.cassandra.schema.Views.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            views.add(SchemaKeyspace.fetchView(keyspaceName, row.getString("view_name"), types));
        }
        return views.build();
    }

    private static ViewDefinition fetchView(String keyspaceName, String viewName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ? AND view_name = ?", NAME, VIEWS);
        UntypedResultSet rows = SchemaKeyspace.query(query, keyspaceName, viewName);
        if (rows.isEmpty()) {
            throw new RuntimeException(String.format("%s:%s not found in the schema definitions keyspace.", keyspaceName, viewName));
        }
        UntypedResultSet.Row row = rows.one();
        UUID id = row.getUUID("id");
        UUID baseTableId = row.getUUID("base_table_id");
        String baseTableName = row.getString("base_table_name");
        boolean includeAll = row.getBoolean("include_all_columns");
        String whereClause = row.getString("where_clause");
        List<ColumnDefinition> columns = SchemaKeyspace.fetchColumns(keyspaceName, viewName, types);
        Map<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns = SchemaKeyspace.fetchDroppedColumns(keyspaceName, viewName);
        CFMetaData cfm = CFMetaData.create(keyspaceName, viewName, id, false, true, false, false, true, columns, DatabaseDescriptor.getPartitioner()).params(SchemaKeyspace.createTableParamsFromRow(row)).droppedColumns(droppedColumns);
        String rawSelect = View.buildSelectStatement(baseTableName, columns, whereClause);
        SelectStatement.RawStatement rawStatement = (SelectStatement.RawStatement)QueryProcessor.parseStatement(rawSelect);
        return new ViewDefinition(keyspaceName, viewName, baseTableId, baseTableName, includeAll, rawStatement, whereClause, cfm);
    }

    private static Functions fetchFunctions(String keyspaceName, Types types) {
        Functions udfs = SchemaKeyspace.fetchUDFs(keyspaceName, types);
        Functions udas = SchemaKeyspace.fetchUDAs(keyspaceName, udfs, types);
        return org.apache.cassandra.schema.Functions.builder().add(udfs).add(udas).build();
    }

    private static Functions fetchUDFs(String keyspaceName, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", NAME, FUNCTIONS);
        Functions.Builder functions = org.apache.cassandra.schema.Functions.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            functions.add((Function)SchemaKeyspace.createUDFFromRow(row, types));
        }
        return functions.build();
    }

    private static UDFunction createUDFFromRow(UntypedResultSet.Row row, Types types) {
        UDFunction udf;
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("function_name");
        FunctionName name = new FunctionName(ksName, functionName);
        ArrayList<ColumnIdentifier> argNames = new ArrayList<ColumnIdentifier>();
        for (String string : row.getFrozenList("argument_names", UTF8Type.instance)) {
            argNames.add(new ColumnIdentifier(string, true));
        }
        ArrayList argTypes = new ArrayList();
        for (String type : row.getFrozenList("argument_types", UTF8Type.instance)) {
            argTypes.add(CQLTypeParser.parse(ksName, type, types));
        }
        AbstractType<?> abstractType = CQLTypeParser.parse(ksName, row.getString("return_type"), types);
        String language = row.getString("language");
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBoolean("called_on_null_input");
        Function existing = Schema.instance.findFunction(name, argTypes).orElse(null);
        if (existing instanceof UDFunction && (udf = (UDFunction)existing).argNames().equals(argNames) && udf.returnType().equals(abstractType) && !udf.isAggregate() && udf.language().equals(language) && udf.body().equals(body) && udf.isCalledOnNullInput() == calledOnNullInput) {
            logger.trace("Skipping duplicate compilation of already existing UDF {}", (Object)name);
            return udf;
        }
        try {
            return UDFunction.create(name, argNames, argTypes, abstractType, calledOnNullInput, language, body);
        }
        catch (InvalidRequestException e) {
            logger.error(String.format("Cannot load function '%s' from schema: this function won't be available (on this node)", name), (Throwable)e);
            return UDFunction.createBrokenFunction(name, argNames, argTypes, abstractType, calledOnNullInput, language, body, e);
        }
    }

    private static Functions fetchUDAs(String keyspaceName, Functions udfs, Types types) {
        String query = String.format("SELECT * FROM %s.%s WHERE keyspace_name = ?", NAME, AGGREGATES);
        Functions.Builder aggregates = org.apache.cassandra.schema.Functions.builder();
        for (UntypedResultSet.Row row : SchemaKeyspace.query(query, keyspaceName)) {
            aggregates.add((Function)SchemaKeyspace.createUDAFromRow(row, udfs, types));
        }
        return aggregates.build();
    }

    private static UDAggregate createUDAFromRow(UntypedResultSet.Row row, Functions functions, Types types) {
        String ksName = row.getString("keyspace_name");
        String functionName = row.getString("aggregate_name");
        FunctionName name = new FunctionName(ksName, functionName);
        List<AbstractType<?>> argTypes = row.getFrozenList("argument_types", UTF8Type.instance).stream().map(t -> CQLTypeParser.parse(ksName, t, types)).collect(Collectors.toList());
        AbstractType<?> returnType = CQLTypeParser.parse(ksName, row.getString("return_type"), types);
        FunctionName stateFunc = new FunctionName(ksName, row.getString("state_func"));
        FunctionName finalFunc = row.has("final_func") ? new FunctionName(ksName, row.getString("final_func")) : null;
        AbstractType<?> stateType = row.has("state_type") ? CQLTypeParser.parse(ksName, row.getString("state_type"), types) : null;
        ByteBuffer initcond = row.has("initcond") ? Terms.asBytes(ksName, row.getString("initcond"), stateType) : null;
        try {
            return UDAggregate.create(functions, name, argTypes, returnType, stateFunc, finalFunc, stateType, initcond);
        }
        catch (InvalidRequestException reason) {
            return UDAggregate.createBroken(name, argTypes, returnType, initcond, reason);
        }
    }

    private static UntypedResultSet query(String query, Object ... variables) {
        return QueryProcessor.executeInternal(query, variables);
    }

    public static synchronized void mergeSchemaAndAnnounceVersion(Collection<Mutation> mutations) throws ConfigurationException {
        SchemaKeyspace.mergeSchema(mutations);
        Schema.instance.updateVersionAndAnnounce();
    }

    public static synchronized void mergeSchema(Collection<Mutation> mutations) {
        Set<String> affectedKeyspaces = mutations.stream().map(m -> (String)UTF8Type.instance.compose(m.key().getKey())).collect(Collectors.toSet());
        Keyspaces before = Schema.instance.getKeyspaces(affectedKeyspaces);
        mutations.forEach(Mutation::apply);
        if (FLUSH_SCHEMA_TABLES) {
            SchemaKeyspace.flush();
        }
        Keyspaces after = SchemaKeyspace.fetchKeyspacesOnly(affectedKeyspaces);
        MapDifference<String, KeyspaceMetadata> keyspacesDiff = before.diff(after);
        for (KeyspaceMetadata keyspaceMetadata : keyspacesDiff.entriesOnlyOnLeft().values()) {
            keyspaceMetadata.functions.udas().forEach(Schema.instance::dropAggregate);
            keyspaceMetadata.functions.udfs().forEach(Schema.instance::dropFunction);
            keyspaceMetadata.views.forEach(v -> Schema.instance.dropView(v.ksName, v.viewName));
            keyspaceMetadata.tables.forEach(t -> Schema.instance.dropTable(t.ksName, t.cfName));
            keyspaceMetadata.types.forEach(Schema.instance::dropType);
            Schema.instance.dropKeyspace(keyspaceMetadata.name);
        }
        for (KeyspaceMetadata keyspaceMetadata : keyspacesDiff.entriesOnlyOnRight().values()) {
            Schema.instance.addKeyspace(KeyspaceMetadata.create(keyspaceMetadata.name, keyspaceMetadata.params));
            keyspaceMetadata.types.forEach(Schema.instance::addType);
            keyspaceMetadata.tables.forEach(Schema.instance::addTable);
            keyspaceMetadata.views.forEach(Schema.instance::addView);
            keyspaceMetadata.functions.udfs().forEach(Schema.instance::addFunction);
            keyspaceMetadata.functions.udas().forEach(Schema.instance::addAggregate);
        }
        for (Map.Entry entry : keyspacesDiff.entriesDiffering().entrySet()) {
            SchemaKeyspace.updateKeyspace((String)entry.getKey(), (KeyspaceMetadata)((MapDifference.ValueDifference)entry.getValue()).leftValue(), (KeyspaceMetadata)((MapDifference.ValueDifference)entry.getValue()).rightValue());
        }
    }

    private static void updateKeyspace(String keyspaceName, KeyspaceMetadata keyspaceBefore, KeyspaceMetadata keyspaceAfter) {
        MapDifference<String, CFMetaData> tablesDiff = keyspaceBefore.tables.diff(keyspaceAfter.tables);
        MapDifference<String, ViewDefinition> viewsDiff = keyspaceBefore.views.diff(keyspaceAfter.views);
        MapDifference<ByteBuffer, UserType> typesDiff = keyspaceBefore.types.diff(keyspaceAfter.types);
        HashMap udfsBefore = new HashMap();
        keyspaceBefore.functions.udfs().forEach(f -> udfsBefore.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        HashMap udfsAfter = new HashMap();
        keyspaceAfter.functions.udfs().forEach(f -> udfsAfter.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        MapDifference udfsDiff = Maps.difference(udfsBefore, udfsAfter);
        HashMap udasBefore = new HashMap();
        keyspaceBefore.functions.udas().forEach(f -> udasBefore.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        HashMap udasAfter = new HashMap();
        keyspaceAfter.functions.udas().forEach(f -> udasAfter.put(Pair.create(f.name(), SchemaKeyspace.functionArgumentsList(f)), f));
        MapDifference udasDiff = Maps.difference(udasBefore, udasAfter);
        if (!keyspaceBefore.params.equals(keyspaceAfter.params)) {
            Schema.instance.updateKeyspace(keyspaceName, keyspaceAfter.params);
        }
        udasDiff.entriesOnlyOnLeft().values().forEach(Schema.instance::dropAggregate);
        udfsDiff.entriesOnlyOnLeft().values().forEach(Schema.instance::dropFunction);
        viewsDiff.entriesOnlyOnLeft().values().forEach(v -> Schema.instance.dropView(v.ksName, v.viewName));
        tablesDiff.entriesOnlyOnLeft().values().forEach(t -> Schema.instance.dropTable(t.ksName, t.cfName));
        typesDiff.entriesOnlyOnLeft().values().forEach(Schema.instance::dropType);
        typesDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addType);
        tablesDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addTable);
        viewsDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addView);
        udfsDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addFunction);
        udasDiff.entriesOnlyOnRight().values().forEach(Schema.instance::addAggregate);
        for (MapDifference.ValueDifference diff : typesDiff.entriesDiffering().values()) {
            Schema.instance.updateType((UserType)diff.rightValue());
        }
        for (MapDifference.ValueDifference diff : tablesDiff.entriesDiffering().values()) {
            Schema.instance.updateTable((CFMetaData)diff.rightValue());
        }
        for (MapDifference.ValueDifference diff : viewsDiff.entriesDiffering().values()) {
            Schema.instance.updateView((ViewDefinition)diff.rightValue());
        }
        for (MapDifference.ValueDifference diff : udfsDiff.entriesDiffering().values()) {
            Schema.instance.updateFunction((UDFunction)diff.rightValue());
        }
        for (MapDifference.ValueDifference diff : udasDiff.entriesDiffering().values()) {
            Schema.instance.updateAggregate((UDAggregate)diff.rightValue());
        }
    }

    private static AbstractType<?> expandUserTypes(AbstractType<?> original) {
        if (original instanceof UserType) {
            return new TupleType(SchemaKeyspace.expandUserTypes(((UserType)original).fieldTypes()));
        }
        if (original instanceof TupleType) {
            return new TupleType(SchemaKeyspace.expandUserTypes(((TupleType)original).allTypes()));
        }
        if (original instanceof ListType) {
            return ListType.getInstance(SchemaKeyspace.expandUserTypes(((ListType)original).getElementsType()), original.isMultiCell());
        }
        if (original instanceof MapType) {
            MapType mt = (MapType)original;
            return MapType.getInstance(SchemaKeyspace.expandUserTypes(mt.getKeysType()), SchemaKeyspace.expandUserTypes(mt.getValuesType()), mt.isMultiCell());
        }
        if (original instanceof SetType) {
            return SetType.getInstance(SchemaKeyspace.expandUserTypes(((SetType)original).getElementsType()), original.isMultiCell());
        }
        if (original instanceof ReversedType) {
            return ReversedType.getInstance(SchemaKeyspace.expandUserTypes(((ReversedType)original).baseType));
        }
        if (original instanceof CompositeType) {
            return CompositeType.getInstance(SchemaKeyspace.expandUserTypes(original.getComponents()));
        }
        return original;
    }

    private static List<AbstractType<?>> expandUserTypes(List<AbstractType<?>> types) {
        return types.stream().map(SchemaKeyspace::expandUserTypes).collect(Collectors.toList());
    }
}

