/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.converter;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.talend.daikon.java8.Function;

public class WrappedList<InT, OutT>
extends AbstractList<OutT> {
    private final List<InT> mWrapped;
    private final Function<InT, OutT> mInFunction;
    private final Function<OutT, InT> mOutFunction;

    WrappedList(List<InT> wrapped, Function<InT, OutT> inFunction, Function<OutT, InT> outFunction) {
        this.mWrapped = wrapped == null ? new ArrayList(0) : wrapped;
        this.mInFunction = inFunction;
        this.mOutFunction = outFunction;
    }

    @Override
    public OutT get(int index) {
        return this.mInFunction.apply(this.mWrapped.get(index));
    }

    @Override
    public boolean contains(Object o) {
        return this.mWrapped.contains(this.mOutFunction.apply(o));
    }

    @Override
    public int size() {
        return this.mWrapped.size();
    }
}

