/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.talend.daikon.converter.Converter;
import org.talend.daikon.exception.TalendRuntimeException;

public class BigDecimalConverter
extends Converter<BigDecimal> {
    public static String PRECISION = "precision";
    public static String SCALE = "scale";
    public static String ROUNDING_MODE = "roundingMode";
    public static String DECIMAL_FORMAT = "decimalFormat";

    @Override
    public BigDecimal convert(Object value) {
        if (value == null) {
            return (BigDecimal)this.returnDefaultValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal castedValue = (BigDecimal)value;
            if (this.properties.containsKey(SCALE)) {
                if (this.properties.containsKey(ROUNDING_MODE)) {
                    return castedValue.setScale((int)this.getScale(), this.getRoundingMode());
                }
                return castedValue.setScale(this.getScale());
            }
            return castedValue;
        }
        if (this.properties.containsKey(DECIMAL_FORMAT)) {
            Number convertedValue = null;
            try {
                convertedValue = this.getDecimalFormat().parse(value.toString());
            }
            catch (ParseException e) {
                throw TalendRuntimeException.createUnexpectedException("Unable to parse " + value);
            }
            return new BigDecimal(convertedValue.toString());
        }
        if (this.properties.containsKey(PRECISION)) {
            if (this.properties.containsKey(ROUNDING_MODE)) {
                return this.convertValue(value, new MathContext(this.getPrecision(), this.getRoundingMode()));
            }
            return this.convertValue(value, new MathContext(this.getPrecision()));
        }
        return this.convertValue(value);
    }

    private BigDecimal convertValue(Object value, MathContext mc) {
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue(), mc);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value, mc);
        }
        if (value instanceof Float) {
            return new BigDecimal(((Float)value).floatValue(), mc);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value, mc);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value, mc);
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue(), mc);
        }
        return new BigDecimal(value.toString(), mc);
    }

    private BigDecimal convertValue(Object value) {
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue());
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Float) {
            return new BigDecimal(((Float)value).floatValue());
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue());
        }
        return new BigDecimal(value.toString());
    }

    public BigDecimalConverter withPrecision(Integer precision) {
        this.properties.put(PRECISION, precision);
        return this;
    }

    public BigDecimalConverter withDecimalFormat(DecimalFormat decimalFormat) {
        this.properties.put(DECIMAL_FORMAT, decimalFormat);
        return this;
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.properties.get(DECIMAL_FORMAT);
    }

    public Integer getPrecision() {
        return (Integer)this.properties.get(PRECISION);
    }

    public BigDecimalConverter withScale(Integer precision) {
        this.properties.put(SCALE, precision);
        return this;
    }

    public Integer getScale() {
        return (Integer)this.properties.get(SCALE);
    }

    public BigDecimalConverter withRoundingMode(RoundingMode mode) {
        this.properties.put(ROUNDING_MODE, mode.toString());
        return this;
    }

    public RoundingMode getRoundingMode() {
        return RoundingMode.valueOf(this.properties.get(ROUNDING_MODE).toString());
    }
}

