/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.talend.daikon.converter.Converter;
import org.talend.daikon.converter.TypeConverterErrorCode;

public class LocalDateTimeConverter
extends Converter<LocalDateTime> {
    public static final String FORMATTER = "formatter";

    @Override
    public LocalDateTime convert(Object value) {
        if (value == null) {
            return (LocalDateTime)this.returnDefaultValue();
        }
        if (this.properties.containsKey(FORMATTER)) {
            try {
                return LocalDateTime.parse(value.toString(), this.getDateTimeFormatter());
            }
            catch (DateTimeParseException dtpe) {
                throw TypeConverterErrorCode.createCannotParseWithFormat(dtpe, value.toString(), this.getDateTimeFormatter().toString());
            }
        }
        return LocalDateTime.parse(value.toString());
    }

    public LocalDateTimeConverter withDateTimeFormatter(DateTimeFormatter formatter) {
        this.properties.put(FORMATTER, formatter);
        return this;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return (DateTimeFormatter)this.properties.get(FORMATTER);
    }
}

