/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.talend.daikon.converter.TypeConverterErrorCode;
import org.talend.daikon.converter.WithFormatConverter;

public abstract class NumberConverter<ThisT extends NumberConverter<ThisT, T>, T extends Number>
extends WithFormatConverter<ThisT, T> {
    public static ShortConverter ofShort() {
        return new ShortConverter();
    }

    public static IntegerConverter ofInteger() {
        return new IntegerConverter();
    }

    public static LongConverter ofLong() {
        return new LongConverter();
    }

    public static FloatConverter ofFloat() {
        return new FloatConverter();
    }

    public static DoubleConverter ofDouble() {
        return new DoubleConverter();
    }

    @Override
    public T convert(Object value) {
        if (value == null) {
            return (T)((Number)this.returnDefaultValue());
        }
        if (value instanceof Number) {
            return this.getFromNumber((Number)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? this.getFromNumber(1) : this.getFromNumber(0);
        }
        if (value instanceof ByteBuffer) {
            return this.getFromByteBuffer(((ByteBuffer)value).slice());
        }
        if (value instanceof CharSequence) {
            CharSequence in = (CharSequence)value;
            if (this.getNumberFormatter() != null) {
                DecimalFormat format = this.getNumberFormatter();
                try {
                    return this.getFromNumber(format.parse(in.toString()));
                }
                catch (ParseException e) {
                    throw TypeConverterErrorCode.createCannotParseWithFormat(e, in.toString(), this.getNumberFormatter().toString());
                }
            }
            if (this.getDateFormatter() != null) {
                DateTimeFormatter format = this.getDateFormatter();
                try {
                    return this.getFromNumber(LocalDate.parse(in, format).toEpochDay());
                }
                catch (DateTimeParseException e) {
                    throw TypeConverterErrorCode.createCannotParseWithFormat(e, in.toString(), format.toString());
                }
            }
            if (this.getTimeMillisFormatter() != null) {
                DateTimeFormatter format = this.getTimeMillisFormatter();
                try {
                    return this.getFromNumber(LocalTime.parse(in, format).toNanoOfDay() / 1000000L);
                }
                catch (DateTimeParseException e) {
                    throw TypeConverterErrorCode.createCannotParseWithFormat(e, in.toString(), format.toString());
                }
            }
            if (this.getTimestampMillisFormatter() != null) {
                DateTimeFormatter format = this.getTimestampMillisFormatter();
                try {
                    return this.getFromNumber(LocalDateTime.parse(in, format).atZone(ZoneOffset.ofTotalSeconds(0)).toInstant().toEpochMilli());
                }
                catch (DateTimeParseException e) {
                    throw TypeConverterErrorCode.createCannotParseWithFormat(e, in.toString(), format.toString());
                }
            }
        }
        return this.getFromString(value.toString());
    }

    protected abstract T getFromNumber(Number var1);

    protected abstract T getFromByteBuffer(ByteBuffer var1);

    protected abstract T getFromString(String var1);

    private static class DoubleConverter
    extends NumberConverter<DoubleConverter, Double> {
        private DoubleConverter() {
        }

        @Override
        protected Double getFromNumber(Number in) {
            return in.doubleValue();
        }

        @Override
        protected Double getFromByteBuffer(ByteBuffer in) {
            return in.getDouble();
        }

        @Override
        protected Double getFromString(String in) {
            return Double.parseDouble(in);
        }
    }

    private static class FloatConverter
    extends NumberConverter<FloatConverter, Float> {
        private FloatConverter() {
        }

        @Override
        protected Float getFromNumber(Number in) {
            return Float.valueOf(in.floatValue());
        }

        @Override
        protected Float getFromByteBuffer(ByteBuffer in) {
            return Float.valueOf(in.getFloat());
        }

        @Override
        protected Float getFromString(String in) {
            return Float.valueOf(Float.parseFloat(in));
        }
    }

    private static class LongConverter
    extends NumberConverter<LongConverter, Long> {
        private LongConverter() {
        }

        @Override
        protected Long getFromNumber(Number in) {
            return in.longValue();
        }

        @Override
        protected Long getFromByteBuffer(ByteBuffer in) {
            return in.getLong();
        }

        @Override
        protected Long getFromString(String in) {
            return Long.parseLong(in);
        }
    }

    private static class IntegerConverter
    extends NumberConverter<IntegerConverter, Integer> {
        private IntegerConverter() {
        }

        @Override
        protected Integer getFromNumber(Number in) {
            return in.intValue();
        }

        @Override
        protected Integer getFromByteBuffer(ByteBuffer in) {
            return in.getInt();
        }

        @Override
        protected Integer getFromString(String in) {
            return Integer.parseInt(in);
        }
    }

    private static class ShortConverter
    extends NumberConverter<ShortConverter, Short> {
        private ShortConverter() {
        }

        @Override
        protected Short getFromNumber(Number in) {
            return in.shortValue();
        }

        @Override
        protected Short getFromByteBuffer(ByteBuffer in) {
            return in.getShort();
        }

        @Override
        protected Short getFromString(String in) {
            return Short.parseShort(in);
        }
    }
}

