/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.converter;

import java.util.Arrays;
import java.util.Collection;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;

public enum TypeConverterErrorCode implements ErrorCode
{
    CANNOT_PARSE("CANNOT_PARSE", 500, "value", "format");

    private final String code;
    private final int httpStatus;
    private final Collection<String> contextEntries;

    private TypeConverterErrorCode(String code, int httpStatus, String ... contextEntries) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.contextEntries = Arrays.asList(contextEntries);
    }

    @Override
    public String getProduct() {
        return "Talend";
    }

    @Override
    public String getGroup() {
        return "ALL";
    }

    @Override
    public int getHttpStatus() {
        return this.httpStatus;
    }

    @Override
    public Collection<String> getExpectedContextEntries() {
        return this.contextEntries;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public static TalendRuntimeException createCannotParseWithFormat(Throwable cause, String value, String format) {
        return new TalendMsgRuntimeException(cause, CANNOT_PARSE, ExceptionContext.withBuilder().put("value", value).put("format", format).build(), "Cannot parse '" + value + "' using the specified format.");
    }

    private static class TalendMsgRuntimeException
    extends TalendRuntimeException {
        private final String localizedMessage;

        public TalendMsgRuntimeException(Throwable cause, ErrorCode code, ExceptionContext context, String localizedMessage) {
            super(code, cause, context);
            this.localizedMessage = localizedMessage;
        }

        @Override
        public String getMessage() {
            return this.getLocalizedMessage();
        }

        @Override
        public String getLocalizedMessage() {
            return this.localizedMessage;
        }
    }
}

