/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.ReferenceProperties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.error.PropertiesErrorCode;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.runtime.RuntimeContext;
import org.talend.daikon.properties.service.Repository;

public final class PropertiesDynamicMethodHelper {
    private static boolean REQUIRED = true;

    private PropertiesDynamicMethodHelper() {
    }

    static Method findMethod(Object instance, String methodType, String propertyName, boolean required, Class<?> ... parameterTypes) {
        if (instance == null) {
            throw new NullPointerException("Instance whose method is being searched for should not be null");
        }
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("The ComponentService was used to access a property with a null(or empty) property name. Type: " + methodType + " Properties: " + instance);
        }
        String methodName = methodType + PropertiesDynamicMethodHelper.capitalizeFirstLetter(propertyName);
        try {
            return instance.getClass().getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (required) {
                throw new IllegalArgumentException("Method: " + methodName + " not found", e);
            }
            return null;
        }
    }

    private static String capitalizeFirstLetter(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static void doInvoke(Properties props, Method m) throws Throwable {
        try {
            m.setAccessible(true);
            Object result = m.invoke((Object)props, new Object[0]);
            PropertiesDynamicMethodHelper.storeResult(props, result);
        }
        catch (InvocationTargetException e) {
            throw new TalendRuntimeException(PropertiesErrorCode.FAILED_INVOKE_METHOD, e, ExceptionContext.withBuilder().put("class", m.getDeclaringClass().getCanonicalName()).put("method", m.getName()).build());
        }
    }

    public static void storeResult(Properties props, Object result) {
        if (result instanceof ValidationResult) {
            ((PropertiesImpl)props).setValidationResult((ValidationResult)result);
        } else {
            ((PropertiesImpl)props).setValidationResult(ValidationResult.OK);
        }
    }

    static void doInvoke(Properties props, Method m, Object ... arguments) throws Throwable {
        try {
            m.setAccessible(true);
            Object result = m.invoke((Object)props, arguments);
            PropertiesDynamicMethodHelper.storeResult(props, result);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw new TalendRuntimeException(PropertiesErrorCode.FAILED_INVOKE_METHOD, e, ExceptionContext.withBuilder().put("class", m.getDeclaringClass().getCanonicalName()).put("method", m.getName()).build());
        }
    }

    public static void validateProperty(Properties props, String propName) throws Throwable {
        Method m = PropertiesDynamicMethodHelper.findMethod(props, "validate", propName, REQUIRED, new Class[0]);
        try {
            m.setAccessible(true);
            ((PropertiesImpl)props).setValidationResult((ValidationResult)m.invoke((Object)props, new Object[0]));
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static void validateProperty(Properties props, String propName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "validate", propName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "validate", propName, !REQUIRED, RuntimeContext.class);
        try {
            ValidationResult result = callbackWithParameters != null ? (ValidationResult)callbackWithParameters.invoke((Object)props, context) : (ValidationResult)callbackWithoutParameters.invoke((Object)props, new Object[0]);
            ((PropertiesImpl)props).setValidationResult(result);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static void beforePropertyActivate(Properties props, String propName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "before", propName, REQUIRED, new Class[0]));
    }

    public static void beforePropertyActivate(Properties props, String propName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "before", propName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "before", propName, !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
        }
    }

    public static void beforePropertyPresent(Properties props, String propName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "before", propName, REQUIRED, new Class[0]));
    }

    public static void beforePropertyPresent(Properties props, String propName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "before", propName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "before", propName, !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
        }
    }

    public static void afterProperty(Properties props, String propName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "after", propName, REQUIRED, new Class[0]));
    }

    public static void afterProperty(Properties props, String propName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "after", propName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "after", propName, !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
        }
    }

    public static void beforeFormPresent(Properties props, String formName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "beforeFormPresent", formName, REQUIRED, new Class[0]));
    }

    public static void beforeFormPresent(Properties props, String formName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "beforeFormPresent", formName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "beforeFormPresent", formName, !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
        }
    }

    public static void afterFormNext(Properties props, String formName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "afterFormNext", formName, REQUIRED, new Class[0]));
    }

    public static void afterFormNext(Properties props, String formName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "afterFormNext", formName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "afterFormNext", formName, !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
        }
    }

    public static void afterFormBack(Properties props, String formName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "afterFormBack", formName, REQUIRED, new Class[0]));
    }

    public static void afterFormBack(Properties props, String formName, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "afterFormBack", formName, REQUIRED, new Class[0]);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "afterFormBack", formName, !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
        }
    }

    public static void afterFormFinish(Properties props, String formName, Repository repostory) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "afterFormFinish", formName, REQUIRED, Repository.class), repostory);
    }

    public static void afterFormFinish(Properties props, String formName, Repository repostory, RuntimeContext context) throws Throwable {
        Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "afterFormFinish", formName, REQUIRED, Repository.class);
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "afterFormFinish", formName, !REQUIRED, Repository.class, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, repostory, context);
        } else {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters, repostory);
        }
    }

    public static void afterReference(Properties props, ReferenceProperties<Properties> refProp) throws Throwable {
        Method afterRefCallback = PropertiesDynamicMethodHelper.findMethod(props, "after", refProp.getName(), !REQUIRED, new Class[0]);
        if (afterRefCallback != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, afterRefCallback);
        }
    }

    public static void afterReference(Properties props, ReferenceProperties<Properties> refProp, RuntimeContext context) throws Throwable {
        Method callbackWithParameters = PropertiesDynamicMethodHelper.findMethod(props, "after", refProp.getName(), !REQUIRED, RuntimeContext.class);
        if (callbackWithParameters != null) {
            PropertiesDynamicMethodHelper.doInvoke(props, callbackWithParameters, context);
        } else {
            Method callbackWithoutParameters = PropertiesDynamicMethodHelper.findMethod(props, "after", refProp.getName(), !REQUIRED, new Class[0]);
            if (callbackWithoutParameters != null) {
                PropertiesDynamicMethodHelper.doInvoke(props, callbackWithoutParameters);
            }
        }
    }

    public static void setFormLayoutMethods(Properties props, String property, Form form) {
        Method m = PropertiesDynamicMethodHelper.findMethod(props, "beforeFormPresent", property, !REQUIRED, new Class[0]);
        if (m != null) {
            form.setCallBeforeFormPresent(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "afterFormBack", property, !REQUIRED, new Class[0])) != null) {
            form.setCallAfterFormBack(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "afterFormNext", property, !REQUIRED, new Class[0])) != null) {
            form.setCallAfterFormNext(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "afterFormFinish", property, !REQUIRED, Repository.class)) != null) {
            form.setCallAfterFormFinish(true);
        }
    }

    public static void setWidgetLayoutMethods(Properties props, String property, Widget widget) {
        Method m = PropertiesDynamicMethodHelper.findMethod(props, "before", property, !REQUIRED, new Class[0]);
        if (m != null) {
            widget.setCallBefore(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "after", property, !REQUIRED, new Class[0])) != null) {
            widget.setCallAfter(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "validate", property, !REQUIRED, new Class[0])) != null) {
            widget.setCallValidate(true);
        }
    }
}

