/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.NamedThing;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.i18n.tag.TranslatableTaggedImpl;
import org.talend.daikon.properties.AnyProperty;
import org.talend.daikon.properties.AnyPropertyVisitor;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesList;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.ValidationResults;
import org.talend.daikon.properties.error.PropertiesErrorCode;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyValueEvaluator;
import org.talend.daikon.properties.property.PropertyVisitor;
import org.talend.daikon.serialize.PostDeserializeSetup;
import org.talend.daikon.serialize.SerializerDeserializer;
import org.talend.daikon.serialize.migration.PostDeserializeHandler;
import org.talend.daikon.strings.ToStringIndent;
import org.talend.daikon.strings.ToStringIndentUtil;

public class PropertiesImpl
extends TranslatableTaggedImpl
implements Properties,
AnyProperty,
PostDeserializeHandler,
ToStringIndent {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesImpl.class);
    private static final long serialVersionUID = -7970336622844281900L;
    private String name;
    private transient List<Form> forms = new ArrayList<Form>();
    private ValidationResult validationResult;
    private transient boolean layoutAlreadyInitalized;
    private transient boolean propsAlreadyInitialized;
    protected static final boolean ENCRYPT = true;

    @Override
    public boolean postDeserialize(int version, PostDeserializeSetup setup, boolean persistent) {
        List<NamedThing> properties;
        if (persistent) {
            properties = this.getProperties();
            for (NamedThing nt : properties) {
                Property property;
                if (!(nt instanceof Property) || !(property = (Property)nt).isFlag(Property.Flags.ENCRYPT)) continue;
                property.encryptStoredValue(false);
            }
        }
        if (setup != null) {
            setup.setup(this);
        }
        properties = this.getProperties();
        for (NamedThing prop : properties) {
            if (prop instanceof Properties) continue;
            prop.setI18nMessageFormatter(this.getI18nMessageFormatter());
        }
        this.propsAlreadyInitialized = true;
        return false;
    }

    public PropertiesImpl(String name) {
        this.setName(name);
    }

    @Override
    public Properties init() {
        this.initProperties();
        this.initLayout();
        return this;
    }

    @Override
    public Properties initForRuntime() {
        this.initProperties();
        return this;
    }

    private void initProperties() {
        if (!this.propsAlreadyInitialized) {
            List<Field> uninitializedProperties = this.initializeFields();
            this.setupProperties();
            for (Field f : uninitializedProperties) {
                try {
                    f.setAccessible(true);
                    NamedThing se = (NamedThing)f.get(this);
                    if (se != null) {
                        this.initializeField(f, se);
                        continue;
                    }
                    if (this.acceptUninitializedField(f)) continue;
                    throw new TalendRuntimeException((ErrorCode)PropertiesErrorCode.PROPERTIES_HAS_UNITIALIZED_PROPS, ExceptionContext.withBuilder().put("name", this.getClass().getCanonicalName()).put("field", f.getName()).build());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
                }
            }
            this.propsAlreadyInitialized = true;
        }
    }

    protected List<Field> initializeFields() {
        Field[] fields;
        ArrayList<Field> uninitializedProperties = new ArrayList<Field>();
        for (Field f : fields = this.getClass().getFields()) {
            try {
                if (!this.isAPropertyType(f.getType())) continue;
                f.setAccessible(true);
                NamedThing se = (NamedThing)f.get(this);
                if (se != null) {
                    this.initializeField(f, se);
                    continue;
                }
                uninitializedProperties.add(f);
            }
            catch (IllegalAccessException e) {
                throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
        return uninitializedProperties;
    }

    protected boolean acceptUninitializedField(Field f) {
        return false;
    }

    protected void initializeField(Field f, NamedThing value) {
        if (!f.getName().equals(value.getName())) {
            throw new IllegalArgumentException("The java field [" + this.getClass().getCanonicalName() + "." + f.getName() + "] should be named identically to the instance name [" + value.getName() + "]");
        }
        if (value instanceof PropertiesList) {
            ((PropertiesImpl)value).initProperties();
            value.setI18nMessageFormatter(this.getI18nMessageFormatter());
        } else if (value instanceof PropertiesImpl) {
            ((PropertiesImpl)value).initProperties();
        } else {
            value.setI18nMessageFormatter(this.getI18nMessageFormatter());
        }
    }

    private void initLayout() {
        if (!this.layoutAlreadyInitalized) {
            List<NamedThing> properties = this.getProperties();
            for (NamedThing prop : properties) {
                if (!(prop instanceof PropertiesImpl)) continue;
                ((PropertiesImpl)prop).initLayout();
            }
            this.setupLayout();
            this.refreshAllFormsLayout();
            this.layoutAlreadyInitalized = true;
        }
    }

    protected void refreshAllFormsLayout() {
        for (Form form : this.getForms()) {
            this.refreshLayout(form);
        }
    }

    @Override
    public void setupProperties() {
    }

    @Override
    public void setupLayout() {
    }

    @Override
    public String toSerialized() {
        this.handleAllPropertyEncryption(true);
        try {
            String string = SerializerDeserializer.toSerialized(this, false);
            return string;
        }
        finally {
            this.handleAllPropertyEncryption(false);
        }
    }

    protected void handleAllPropertyEncryption(final boolean encrypt) {
        this.accept(new PropertyVisitor(){

            @Override
            public void visit(Property property, Properties parent) {
                if (property.isFlag(Property.Flags.ENCRYPT)) {
                    property.encryptStoredValue(encrypt);
                }
            }
        }, null);
    }

    @Override
    public void refreshLayout(Form form) {
        if (form != null) {
            form.setRefreshUI(true);
        }
    }

    @Override
    public List<Form> getForms() {
        return this.forms;
    }

    @Override
    public Form getForm(String formName) {
        String wantedFormName = StringUtils.isBlank((CharSequence)formName) ? "Main" : formName;
        for (Form f : this.forms) {
            if (!f.getName().equals(wantedFormName)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Form getPreferredForm(String formName) {
        if (formName == null) {
            return null;
        }
        Form form = this.getForm(formName);
        if (form != null) {
            return form;
        }
        if (formName.equals("CitizenUser")) {
            return this.getForm("Main");
        }
        return form;
    }

    @Override
    public void addForm(Form form) {
        this.forms.add(form);
    }

    @Override
    public List<NamedThing> getProperties() {
        ArrayList<NamedThing> properties = new ArrayList<NamedThing>();
        List<Field> propertyFields = this.getAnyPropertyFields();
        for (Field f : propertyFields) {
            try {
                if (!NamedThing.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                Object fValue = f.get(this);
                if (fValue == null) continue;
                NamedThing se = (NamedThing)fValue;
                properties.add(se);
            }
            catch (IllegalAccessException e) {
                throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
        return properties;
    }

    private List<Field> getAnyPropertyFields() {
        Field[] fields;
        ArrayList<Field> propertyFields = new ArrayList<Field>();
        for (Field f : fields = this.getClass().getFields()) {
            if (!this.isAPropertyType(f.getType())) continue;
            propertyFields.add(f);
        }
        return propertyFields;
    }

    @Override
    public void accept(AnyPropertyVisitor visitor, Properties parent) {
        Set<Properties> visited = Collections.newSetFromMap(new IdentityHashMap());
        this.acceptInternal(visitor, parent, visited);
    }

    private void acceptInternal(AnyPropertyVisitor visitor, Properties parent, Set<Properties> visited) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        this.acceptForAllProperties(visitor, visited);
        visitor.visit(this, parent);
    }

    protected void acceptForAllProperties(AnyPropertyVisitor visitor, Set<Properties> visited) {
        List<NamedThing> properties = this.getProperties();
        for (NamedThing nt : properties) {
            this.acceptForProperty(visitor, visited, nt);
        }
    }

    protected final void acceptForProperty(AnyPropertyVisitor visitor, Set<Properties> visited, NamedThing nt) {
        if (nt instanceof PropertiesImpl) {
            ((PropertiesImpl)nt).acceptInternal(visitor, this, visited);
        } else if (nt instanceof AnyProperty) {
            ((AnyProperty)nt).accept(visitor, this);
        }
    }

    protected boolean isAPropertyType(Class<?> clazz) {
        return AnyProperty.class.isAssignableFrom(clazz);
    }

    @Override
    public NamedThing getProperty(String propPath) {
        if (propPath != null) {
            String[] propComps = propPath.split("\\.");
            PropertiesImpl currentProps = this;
            int i = 0;
            for (String prop : propComps) {
                if (i++ == propComps.length - 1) {
                    return currentProps.getLocalProperty(prop);
                }
                NamedThing se = currentProps.getLocalProperty(prop);
                if (!(se instanceof PropertiesImpl)) {
                    return null;
                }
                currentProps = (PropertiesImpl)se;
            }
        }
        return null;
    }

    @Override
    public Property<?> getValuedProperty(String propPath) {
        NamedThing prop = this.getProperty(propPath);
        return prop instanceof Property ? (Property)prop : null;
    }

    @Override
    public Properties getProperties(String propPath) {
        NamedThing prop = this.getProperty(propPath);
        return prop instanceof Properties ? (Properties)prop : null;
    }

    protected NamedThing getLocalProperty(String propName) {
        List<NamedThing> properties = this.getProperties();
        for (NamedThing prop : properties) {
            if (!propName.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public void setValue(String property, Object value) {
        NamedThing p = this.getProperty(property);
        if (!(p instanceof Property)) {
            throw new IllegalArgumentException("setValue but property: " + property + " is not a Property");
        }
        ((Property)p).setValue(value);
    }

    @Override
    public void setValueEvaluator(PropertyValueEvaluator ve) {
        List<NamedThing> properties = this.getProperties();
        for (NamedThing prop : properties) {
            if (prop instanceof Property) {
                ((Property)prop).setValueEvaluator(ve);
                continue;
            }
            if (!(prop instanceof Properties)) continue;
            ((Properties)prop).setValueEvaluator(ve);
        }
    }

    public void setValidationResult(ValidationResult vr) {
        this.validationResult = vr;
    }

    @Override
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Override
    public void assignNestedProperties(Properties ... newValueProperties) {
        List<Field> propertyFields = this.getAnyPropertyFields();
        for (Field propField : propertyFields) {
            Class<?> propType = propField.getType();
            if (!Properties.class.isAssignableFrom(propType)) continue;
            boolean isNewAssignment = false;
            for (Properties newValue : newValueProperties) {
                if (!propType.isAssignableFrom(newValue.getClass())) continue;
                try {
                    propField.set(this, newValue);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
                }
                isNewAssignment = true;
            }
            if (isNewAssignment) continue;
            try {
                Properties prop = (Properties)propField.get(this);
                if (prop == null) continue;
                prop.assignNestedProperties(newValueProperties);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
    }

    @Override
    public void copyValuesFrom(Properties props) {
        this.copyValuesFrom(props, true, true);
    }

    @Override
    public void copyValuesFrom(Properties props, boolean copyTaggedValues, boolean copyEvaluators) {
        for (NamedThing otherProp : props.getProperties()) {
            NamedThing thisProp = this.getProperty(otherProp.getName());
            if (thisProp == null) {
                try {
                    Field f = this.getClass().getField(otherProp.getName());
                    thisProp = this.createPropertyInstance(otherProp);
                    f.set(this, thisProp);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (ReflectiveOperationException | SecurityException e) {
                    throw TalendRuntimeException.createUnexpectedException(e);
                }
            }
            if (otherProp instanceof PropertiesImpl) {
                ((PropertiesImpl)thisProp).copyValuesFrom((Properties)otherProp);
                ((PropertiesImpl)thisProp).refreshAllFormsLayout();
                continue;
            }
            if (otherProp instanceof Property) {
                Object value = ((Property)otherProp).getStoredValue();
                ((Property)thisProp).setStoredValue(value);
                if (copyTaggedValues) {
                    ((Property)thisProp).copyTaggedValues((Property)otherProp);
                }
                if (!copyEvaluators) continue;
                ((Property)thisProp).setValueEvaluator(((Property)otherProp).getValueEvaluator());
                continue;
            }
            LOG.debug("Do not copy [" + otherProp + "]");
        }
    }

    @Override
    public NamedThing createPropertyInstance(NamedThing otherProp) throws ReflectiveOperationException {
        NamedThing thisProp = null;
        Class<?> otherClass = otherProp.getClass();
        if (Property.class.isAssignableFrom(otherClass)) {
            Property otherPy = (Property)otherProp;
            Constructor<?> c = otherClass.getDeclaredConstructor(String.class, String.class);
            c.setAccessible(true);
            thisProp = (NamedThing)c.newInstance(otherPy.getType(), otherPy.getName());
        } else if (Properties.class.isAssignableFrom(otherClass)) {
            Constructor<?>[] constructors;
            for (Constructor<?> c : constructors = otherClass.getConstructors()) {
                Class<?>[] pts = c.getParameterTypes();
                c.setAccessible(true);
                if (pts.length == 1 && String.class.isAssignableFrom(pts[0])) {
                    thisProp = (NamedThing)c.newInstance(otherProp.getName());
                    break;
                }
                if (pts.length != 2 || !Properties.class.isAssignableFrom(pts[0]) || !String.class.isAssignableFrom(pts[1])) continue;
                thisProp = (NamedThing)c.newInstance(this, otherProp.getName());
                break;
            }
            if (thisProp == null) {
                throw TalendRuntimeException.createUnexpectedException("Failed to find a proper constructor in Properties : " + otherClass.getName());
            }
        } else {
            throw TalendRuntimeException.createUnexpectedException("Unexpected property class: " + otherProp.getClass() + " prop: " + otherProp);
        }
        return thisProp;
    }

    public static <P extends Properties> P createNewInstance(Class<P> propClass, String name) {
        try {
            Constructor<P> stringConstructor = propClass.getConstructor(String.class);
            if (stringConstructor != null) {
                return (P)((Properties)stringConstructor.newInstance(name));
            }
            throw TalendRuntimeException.createUnexpectedException("Could not find a suitable constructor for class [" + propClass.getName() + "]");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw TalendRuntimeException.createUnexpectedException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.getName() != null ? this.getI18nMessage("properties." + this.getName() + ".displayName", new Object[0]) : "";
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public String toString() {
        return this.toStringIndent(0);
    }

    @Override
    public String toStringIndent(int indent) {
        StringBuilder sb = new StringBuilder();
        String is = ToStringIndentUtil.indentString(indent);
        sb.append(is + this.getName() + " - " + this.getTitle() + " " + this.getClass().getName());
        sb.append("\n" + is + "   Properties:");
        for (NamedThing prop : this.getProperties()) {
            String value;
            if (prop instanceof ToStringIndent) {
                sb.append('\n' + ((ToStringIndent)((Object)prop)).toStringIndent(indent + 6));
            } else {
                sb.append('\n' + prop.toString());
            }
            if ((value = prop instanceof Property ? ((Property)prop).getStringValue() : null) == null) continue;
            sb.append(" [" + value + "]");
        }
        sb.append("\n " + is + "  Forms:");
        if (this.getForms() != null) {
            for (Form form : this.getForms()) {
                sb.append("\n" + form.toStringIndent(indent + 6));
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        final HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 5);
        this.accept(new PropertyVisitor(){

            @Override
            public void visit(Property property, Properties parent) {
                hashCodeBuilder.append((Object)property.getName());
                hashCodeBuilder.append(property.getStoredValue());
            }
        }, null);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertiesImpl other = (PropertiesImpl)obj;
        return this.computeEqualityWith(this, other);
    }

    boolean computeEqualityWith(Properties current, Properties other) {
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        List<NamedThing> properties = current.getProperties();
        for (NamedThing nt : properties) {
            if (nt instanceof PropertiesImpl) {
                equalsBuilder.append((Object)nt, (Object)other.getProperties(nt.getName()));
                continue;
            }
            if (!(nt instanceof Property)) continue;
            equalsBuilder.append((Object)nt, other.getValuedProperty(nt.getName()));
        }
        return equalsBuilder.isEquals();
    }

    @Override
    public ValidationResults validate() {
        return new ValidationResults();
    }
}

