/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.properties.Properties;

public class PropertiesUtils {
    public static <P extends Properties, V> void injectObject(P props, V injectable) {
        PropertiesUtils.injectObject(props, injectable, new HashSet<Object>());
    }

    public static <P extends Properties, V> void injectObject(P props, V injectable, Set<Object> alreadyUpdated) {
        if (!alreadyUpdated.add(props)) {
            return;
        }
        if (props == null) {
            return;
        }
        for (Class<?> cls = props.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                Inject ann = field.getAnnotation(Inject.class);
                PropertiesUtils.injectField((Annotation)ann, field, props, injectable, alreadyUpdated);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <P extends Properties, V> void injectField(Annotation ann, Field field, P props, V injectable, Set<Object> alreadyUpdated) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (ann != null && field.getType().isAssignableFrom(injectable.getClass())) {
            try {
                if (field.get(props) != null) return;
                field.set(props, injectable);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw TalendRuntimeException.createUnexpectedException(e);
            }
        }
        if (!Properties.class.isAssignableFrom(field.getType())) return;
        try {
            PropertiesUtils.injectObject((Properties)field.get(props), injectable, alreadyUpdated);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw TalendRuntimeException.createUnexpectedException(e);
        }
    }
}

