/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.property;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.properties.property.Property;

public class EnumListProperty<T extends Enum<T>>
extends Property<List<T>> {
    private static final long serialVersionUID = -8815508005750292147L;

    public EnumListProperty(TypeLiteral<List<T>> type, String name) {
        super(type, name, null);
        Object[] enumConstants = (Enum[])((Class)((ParameterizedType)type.value).getActualTypeArguments()[0]).getEnumConstants();
        this.setPossibleValues(enumConstants);
    }

    EnumListProperty(String type, String name) {
        super(type, name);
    }

    @Override
    public List<T> getValue() {
        if (this.storedValue == null) {
            return null;
        }
        List value = (List)this.storedValue;
        if (this.propertyValueEvaluator != null) {
            value = (List)this.propertyValueEvaluator.evaluate(this, this.storedValue);
        }
        ArrayList convertedValue = new ArrayList();
        boolean converted = false;
        try {
            String enumClassName = this.getType().substring("java.util.List<".length(), this.getType().length() - 1);
            for (Object v : value) {
                if (!(v instanceof String)) continue;
                converted = true;
                Class enumClass = ClassUtils.getClass((String)enumClassName);
                convertedValue.add(Enum.valueOf(enumClass, (String)v));
            }
        }
        catch (ClassNotFoundException e) {
            TalendRuntimeException.unexpectedException(e);
        }
        return converted ? convertedValue : value;
    }

    String convertToInnerClassString(String type) {
        return StringUtils.replacePattern((String)type, (String)"([a-z0-9]*\\\\.[A-Z][^.]*)?((\\\\.)([A-Z][a-z0-9]*))", (String)"$1\\$$4");
    }
}

