/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.property;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.talend.daikon.NamedThing;
import org.talend.daikon.SimpleNamedThing;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.AnyProperty;
import org.talend.daikon.properties.AnyPropertyVisitor;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.property.PropertyValueEvaluator;
import org.talend.daikon.properties.validation.Validator;
import org.talend.daikon.strings.ToStringIndentUtil;

public class Property<T>
extends SimpleNamedThing
implements AnyProperty {
    public static final String I18N_PROPERTY_POSSIBLE_VALUE_PREFIX = "property.possiblevalue.";
    public static final int INFINITE = -1;
    private static final long serialVersionUID = 6151130865421353629L;
    private static final String I18N_PROPERTY_PREFIX = "property.";
    protected EnumSet<Flags> flags;
    protected Object storedValue;
    protected Object storedDefaultValue;
    protected transient Validator<T> validator;
    protected transient PropertyValueEvaluator propertyValueEvaluator;
    protected List<Property<?>> children = new ArrayList();
    private Map<String, Object> taggedValues = new HashMap<String, Object>();
    private int size;
    private int occurMinTimes;
    private int occurMaxTimes;
    private int precision;
    private String pattern;
    private boolean nullable;
    private List<?> possibleValues;
    private String currentType;

    Property(TypeLiteral<T> type, String name, String title) {
        this(type.getType(), name, title);
    }

    Property(TypeLiteral<T> type, String name) {
        this(type, name, null);
    }

    Property(Type type, String name, String title) {
        this(TypeUtils.toString((Type)type), name, title);
    }

    Property(String type, String name) {
        this(type, name, null);
    }

    Property(String type, String name, String title) {
        this.currentType = type;
        this.setName(name);
        this.setTitle(title);
        this.setSize(-1);
    }

    Property(Class<T> type, String name) {
        this(type, name, null);
    }

    Property(Class<T> type, String name, String title) {
        this((Type)type, name, title);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Property<T> setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Property<T> setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getType() {
        return this.currentType;
    }

    public int getSize() {
        return this.size;
    }

    public Property<T> setSize(int size) {
        this.size = size;
        return this;
    }

    public boolean isSizeUnbounded() {
        return this.size == -1;
    }

    public int getOccurMinTimes() {
        return this.occurMinTimes;
    }

    public Property<T> setOccurMinTimes(int times) {
        this.occurMinTimes = times;
        return this;
    }

    public int getOccurMaxTimes() {
        return this.occurMaxTimes;
    }

    public Property<T> setOccurMaxTimes(int times) {
        this.occurMaxTimes = times;
        return this;
    }

    public boolean isRequired() {
        return this.occurMinTimes > 0;
    }

    public Property<T> setRequired(boolean required) {
        if (required) {
            this.setOccurMinTimes(1);
        } else {
            this.setOccurMinTimes(0);
        }
        this.setOccurMaxTimes(1);
        return this;
    }

    public Property<T> setRequired() {
        return this.setRequired(true);
    }

    public int getPrecision() {
        return this.precision;
    }

    public Property<T> setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Property<T> setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Property<T> setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public List<?> getPossibleValues() {
        return this.possibleValues == null ? Collections.emptyList() : this.possibleValues;
    }

    @JsonIgnore
    public Property<T> setPossibleValues(List<?> possibleValues) {
        this.possibleValues = possibleValues;
        return this;
    }

    public Property<T> setPossibleValues(Object ... values) {
        this.possibleValues = Arrays.asList(values);
        return this;
    }

    public EnumSet<Flags> getFlags() {
        return this.flags;
    }

    public Property<T> setFlags(EnumSet<Flags> flags) {
        this.flags = flags;
        return this;
    }

    public boolean isFlag(Flags flag) {
        if (this.flags == null) {
            return false;
        }
        return this.flags.contains((Object)flag);
    }

    public void addFlag(Flags flag) {
        if (this.flags == null) {
            this.flags = EnumSet.of(flag);
        } else {
            EnumSet<Flags> newFlags = EnumSet.of(flag);
            newFlags.addAll(this.flags);
            this.flags = newFlags;
        }
    }

    public void removeFlag(Flags flag) {
        if (this.flags != null) {
            this.flags.remove((Object)flag);
        }
    }

    public Object getStoredValue() {
        return this.storedValue;
    }

    public Property<T> setStoredValue(Object value) {
        this.storedValue = value;
        return this;
    }

    public T getValue() {
        if (this.propertyValueEvaluator != null) {
            return this.propertyValueEvaluator.evaluate(this, this.storedValue);
        }
        return (T)this.storedValue;
    }

    public T getDefaultValue() {
        if (this.propertyValueEvaluator != null) {
            return this.propertyValueEvaluator.evaluate(this, this.storedDefaultValue);
        }
        return (T)this.storedDefaultValue;
    }

    public Property<T> setValue(T value) {
        this.storedValue = value;
        return this;
    }

    protected Property<T> setDefaultValue(T value) {
        this.storedDefaultValue = value;
        return this;
    }

    public String getStringValue() {
        T value = this.getValue();
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public String getStringDefaultValue() {
        if (this.getDefaultValue() == null) {
            return null;
        }
        return String.valueOf(this.getDefaultValue());
    }

    @Override
    public String toString() {
        return "Property: " + this.getName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getI18nMessage(I18N_PROPERTY_PREFIX + this.name + ".displayName", new Object[0]);
    }

    public Property<T> setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getPossibleValuesDisplayName(Object possibleValue) {
        if (!this.isAPossibleValue(possibleValue)) {
            throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_ARGUMENT, ExceptionContext.build().put("argument", "possibleValues").put("value", possibleValue));
        }
        if (possibleValue != null) {
            String i18nMessage;
            String possibleValueDisplayName = possibleValue.toString();
            if (NamedThing.class.isAssignableFrom(possibleValue.getClass())) {
                possibleValueDisplayName = ((NamedThing)possibleValue).getDisplayName();
            }
            if ((i18nMessage = this.getI18nMessage(I18N_PROPERTY_POSSIBLE_VALUE_PREFIX + possibleValueDisplayName + ".displayName", new Object[0])).endsWith(".displayName")) {
                return possibleValueDisplayName;
            }
            return i18nMessage;
        }
        return "null";
    }

    protected boolean isAPossibleValue(Object possibleValue) {
        if (this.getPossibleValues() != null) {
            return this.getPossibleValues().contains(possibleValue);
        }
        return false;
    }

    public void setTaggedValue(String key, Object value) {
        this.taggedValues.put(key, value);
    }

    public Object getTaggedValue(String key) {
        return this.taggedValues.get(key);
    }

    public PropertyValueEvaluator getValueEvaluator() {
        return this.propertyValueEvaluator;
    }

    public void setValueEvaluator(PropertyValueEvaluator ve) {
        this.propertyValueEvaluator = ve;
    }

    @Override
    public void accept(AnyPropertyVisitor visitor, Properties parent) {
        visitor.visit(this, parent);
    }

    public String toStringIndent(int indent) {
        return ToStringIndentUtil.indentString(indent) + this.getName();
    }

    public void copyTaggedValues(Property otherProp) {
        this.taggedValues.putAll(otherProp.taggedValues);
    }

    public void encryptStoredValue(boolean encrypt) {
    }

    public ValidationResult validate() {
        if (this.validator == null) {
            return ValidationResult.OK;
        }
        return this.validator.validate(this.getValue());
    }

    public Property<T> setValidator(Validator<T> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.storedValue == null ? 0 : this.storedValue.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.storedValue, other.storedValue).isEquals();
    }

    public static enum Flags {
        ENCRYPT,
        SUPPRESS_LOGGING,
        DESIGN_TIME_ONLY,
        HIDDEN;

    }
}

