/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.sandbox;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import org.talend.daikon.runtime.RuntimeInfo;
import org.talend.daikon.sandbox.SandboxControl;
import org.talend.daikon.sandbox.SandboxedInstance;
import org.talend.daikon.sandbox.properties.ClassLoaderIsolatedSystemProperties;
import org.talend.java.util.ClosableLRUMap;

public class SandboxInstanceFactory {
    static Map<RuntimeInfo, ClassLoader> classLoaderCache = Collections.synchronizedMap(new ClosableLRUMap(3, 10));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SandboxedInstance createSandboxedInstance(RuntimeInfo runtimeInfo, ClassLoader parentClassLoader, boolean useCurrentJvmProperties) {
        ClassLoader sandboxClassLoader;
        if (runtimeInfo.getRuntimeClassName() == null) {
            throw new IllegalArgumentException("classToInstantiate should not be null");
        }
        if (SandboxInstanceFactory.isClassLoaderReusable(runtimeInfo)) {
            Map<RuntimeInfo, ClassLoader> map = classLoaderCache;
            synchronized (map) {
                if (SandboxInstanceFactory.isClassLoaderCached(runtimeInfo)) {
                    sandboxClassLoader = classLoaderCache.get(runtimeInfo);
                } else {
                    sandboxClassLoader = SandboxInstanceFactory.createClassLoader(runtimeInfo, parentClassLoader);
                    classLoaderCache.put(runtimeInfo, sandboxClassLoader);
                }
            }
        } else {
            sandboxClassLoader = SandboxInstanceFactory.createClassLoader(runtimeInfo, parentClassLoader);
        }
        return new SandboxedInstance(runtimeInfo.getRuntimeClassName(), useCurrentJvmProperties, sandboxClassLoader, SandboxInstanceFactory.isClassLoaderReusable(runtimeInfo));
    }

    private static URLClassLoader createClassLoader(RuntimeInfo runtimeInfo, ClassLoader parentClassLoader) {
        return new URLClassLoader(runtimeInfo.getMavenUrlDependencies().toArray(new URL[runtimeInfo.getMavenUrlDependencies().size()]), parentClassLoader){

            @Override
            public void close() throws IOException {
                super.close();
                ClassLoaderIsolatedSystemProperties.getInstance().stopIsolateClassLoader(this);
            }
        };
    }

    private static boolean isClassLoaderReusable(RuntimeInfo runtimeInfo) {
        if (runtimeInfo instanceof SandboxControl) {
            return ((SandboxControl)((Object)runtimeInfo)).isClassLoaderReusable();
        }
        return true;
    }

    private static boolean isClassLoaderCached(RuntimeInfo runtimeInfo) {
        return classLoaderCache.containsKey(runtimeInfo) && classLoaderCache.get(runtimeInfo) != null;
    }

    public static void clearCache() {
        classLoaderCache.clear();
    }

    static {
        ClassLoaderIsolatedSystemProperties isolatedSystemProperties = ClassLoaderIsolatedSystemProperties.getInstance();
        if (!(System.getProperties() instanceof ClassLoaderIsolatedSystemProperties)) {
            System.setProperties(isolatedSystemProperties);
        }
    }
}

