/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class SSLContextProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyManager[] buildKeyManagers(String path, String storePass, String keytype) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        try (InputStream stream = null;){
            if (StringUtils.isEmpty((CharSequence)path)) {
                KeyManager[] keyManagerArray = null;
                return keyManagerArray;
            }
            if (!new File(path).exists()) {
                throw new KeyStoreException("Key store not exist");
            }
            stream = new FileInputStream(path);
            KeyStore tks = KeyStore.getInstance(keytype);
            tks.load(stream, storePass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(tks, storePass.toCharArray());
            KeyManager[] keyManagerArray = kmf.getKeyManagers();
            return keyManagerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManager[] buildTrustManagers(String path, String storePass, String trusttype) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        try (InputStream stream = null;){
            if (StringUtils.isEmpty((CharSequence)path)) {
                TrustManager[] trustManagerArray = null;
                return trustManagerArray;
            }
            if (StringUtils.isEmpty((CharSequence)path) || !new File(path).exists()) {
                throw new KeyStoreException("Trust store not exist");
            }
            stream = new FileInputStream(path);
            KeyStore tks = KeyStore.getInstance(trusttype);
            tks.load(stream, storePass.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(tks);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
    }

    public static synchronized SSLContext buildContext(String algorithm, String keypath, String keypass, String keytype, String trustpath, String trustpass, String trusttype) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException {
        KeyManager[] kms = SSLContextProvider.buildKeyManagers(keypath, keypass, keytype);
        TrustManager[] tms = SSLContextProvider.buildTrustManagers(trustpath, trustpass, trusttype);
        SSLContext context = SSLContext.getInstance(algorithm);
        context.init(kms, tms, null);
        return context;
    }
}

