/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.talend.daikon.definition.Definition;
import org.talend.daikon.definition.service.DefinitionRegistryService;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.serialize.jsonschema.JsonDataGenerator;
import org.talend.daikon.serialize.jsonschema.JsonPropertiesResolver;
import org.talend.daikon.serialize.jsonschema.JsonSchemaGenerator;
import org.talend.daikon.serialize.jsonschema.UiSchemaGenerator;

public class JsonSchemaUtil {
    public static final String TAG_JSON_SCHEMA = "jsonSchema";
    public static final String TAG_JSON_UI = "uiSchema";
    public static final String TAG_JSON_DATA = "properties";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator();
    private static final UiSchemaGenerator uiSchemaGenerator = new UiSchemaGenerator();
    private static final JsonDataGenerator jsonDataGenerator = new JsonDataGenerator();
    private static final JsonPropertiesResolver resolver = new JsonPropertiesResolver();

    public static <P extends Properties> P fromJson(String jsonStr, P initialInstance) {
        try {
            JsonNode jsonNode = mapper.readTree(jsonStr);
            return JsonSchemaUtil.fromJson(jsonNode, initialInstance);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw TalendRuntimeException.createUnexpectedException(e);
        }
    }

    public static Properties fromJson(String jsonStr, DefinitionRegistryService defRegistryService) {
        try {
            JsonNode jsonNode = mapper.readTree(jsonStr);
            return JsonSchemaUtil.fromJsonNode(defRegistryService, jsonNode);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw TalendRuntimeException.createUnexpectedException(e);
        }
    }

    static Properties fromJsonNode(DefinitionRegistryService defRegistryService, JsonNode jsonNode) throws NoSuchMethodException, IOException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        JsonNode defNameNode = jsonNode.get("@definitionName");
        if (defNameNode == null) {
            throw TalendRuntimeException.build(CommonErrorCodes.UNABLE_TO_PARSE_JSON).create();
        }
        Definition definition = defRegistryService.getDefinitionsMapByType(Definition.class).get(defNameNode.asText());
        if (definition == null) {
            throw TalendRuntimeException.build(CommonErrorCodes.UNREGISTERED_DEFINITION).set(defNameNode.asText());
        }
        return JsonSchemaUtil.fromJson(jsonNode, defRegistryService.createProperties(definition, "root").init());
    }

    public static Properties fromJson(InputStream jsonIS, DefinitionRegistryService defRegistryService) {
        try {
            JsonNode jsonNode = mapper.readTree(jsonIS);
            return JsonSchemaUtil.fromJsonNode(defRegistryService, jsonNode);
        }
        catch (Exception e) {
            throw TalendRuntimeException.createUnexpectedException(e);
        }
    }

    public static <P extends Properties> P fromJson(InputStream inputStream, P initialInstance) {
        try {
            JsonNode jsonNode = mapper.readTree(inputStream);
            return JsonSchemaUtil.fromJson(jsonNode, initialInstance);
        }
        catch (Exception e) {
            throw TalendRuntimeException.createUnexpectedException(e);
        }
    }

    private static <P extends Properties> P fromJson(JsonNode jsonData, P initialInstance) throws NoSuchMethodException, IOException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (jsonData == null) {
            throw TalendRuntimeException.createUnexpectedException("jsonSchema or properties should not be null");
        }
        return resolver.resolveJson((ObjectNode)jsonData, initialInstance);
    }

    public static String toJson(Properties cp, String formName, String definitionName) {
        ObjectNode objectNode = mapper.createObjectNode();
        objectNode.set(TAG_JSON_SCHEMA, (JsonNode)jsonSchemaGenerator.generateJsonSchema(cp, formName));
        objectNode.set(TAG_JSON_DATA, (JsonNode)jsonDataGenerator.genData(cp, formName, definitionName));
        if (!cp.getForms().isEmpty()) {
            objectNode.set(TAG_JSON_UI, (JsonNode)uiSchemaGenerator.genWidget(cp, formName));
        }
        return objectNode.toString();
    }
}

