/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.PresentationItem;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.serialize.jsonschema.JsonBaseTool;
import org.talend.daikon.serialize.jsonschema.JsonWidget;
import org.talend.daikon.serialize.jsonschema.PropertyTrigger;
import org.talend.daikon.serialize.jsonschema.UiSchemaConstants;
import org.talend.daikon.serialize.jsonschema.mapping.Mapper;

public class UiSchemaGenerator {
    protected <T extends Properties> ObjectNode genWidget(T properties, String formName) {
        return this.processTPropertiesWidget(properties, formName);
    }

    private ObjectNode processTPropertiesWidget(Properties cProperties, String formName) {
        Form mainForm = cProperties.getPreferredForm(formName);
        return this.processTPropertiesWidget(mainForm, new boolean[]{false});
    }

    private ObjectNode processTPropertiesWidget(Form form, boolean[] hasVisible) {
        String propName;
        ObjectNode jsonToReturn = JsonNodeFactory.instance.objectNode();
        if (form == null) {
            return jsonToReturn;
        }
        List<JsonWidget> jsonWidgets = this.listTypedWidget(form);
        TreeMap<Integer, String> order = new TreeMap<Integer, String>();
        Properties cProperties = form.getProperties();
        List<Property> propertyList = JsonBaseTool.getSubProperty(cProperties);
        List<Properties> propertiesList = JsonBaseTool.getSubProperties(cProperties);
        for (JsonWidget jsonWidget : jsonWidgets) {
            NamedThing content = jsonWidget.getContent();
            if (propertyList.contains(content) || content instanceof PresentationItem) {
                ObjectNode jsonNodes = this.processTWidget(jsonWidget.getWidget(), JsonNodeFactory.instance.objectNode(), hasVisible);
                if (jsonNodes.size() != 0) {
                    jsonToReturn.set(jsonWidget.getName(), (JsonNode)jsonNodes);
                }
                order.put(jsonWidget.getOrder(), jsonWidget.getName());
                continue;
            }
            Properties checkProperties = null;
            Form resolveForm = null;
            if (content instanceof Form) {
                resolveForm = (Form)content;
                checkProperties = resolveForm.getProperties();
            } else {
                checkProperties = (Properties)content;
                resolveForm = null;
            }
            if (!propertiesList.contains(checkProperties)) continue;
            ObjectNode jsonNodes = null;
            if (resolveForm != null) {
                boolean[] subFormVisible = new boolean[]{false};
                jsonNodes = this.processTPropertiesWidget(resolveForm, subFormVisible);
                if (subFormVisible[0]) {
                    hasVisible[0] = true;
                }
                jsonNodes = this.processTWidget(jsonWidget.getWidget(), jsonNodes, hasVisible);
            } else {
                jsonNodes = this.processTWidget(jsonWidget.getWidget(), JsonNodeFactory.instance.objectNode(), hasVisible);
            }
            order.put(jsonWidget.getOrder(), jsonWidget.getName());
            if (jsonNodes.size() == 0) continue;
            jsonToReturn.set(jsonWidget.getName(), (JsonNode)jsonNodes);
        }
        ArrayNode orderSchema = jsonToReturn.putArray("ui:order");
        for (Integer i : order.keySet()) {
            orderSchema.add((String)order.get(i));
        }
        for (Property property : propertyList) {
            propName = property.getName();
            if (order.values().contains(propName)) continue;
            orderSchema.add(propName);
            jsonToReturn.set(propName, (JsonNode)this.setHiddenWidget(JsonNodeFactory.instance.objectNode()));
        }
        for (Properties properties : propertiesList) {
            propName = properties.getName();
            if (order.values().contains(propName)) continue;
            jsonToReturn.set(propName, (JsonNode)this.setHiddenWidget(JsonNodeFactory.instance.objectNode()));
            orderSchema.add(propName);
        }
        if (!hasVisible[0]) {
            this.setHiddenWidget(jsonToReturn);
        }
        return jsonToReturn;
    }

    private ObjectNode processTWidget(Widget widget, ObjectNode schema, boolean[] hasVisible) {
        if (widget.isHidden()) {
            NamedThing content = widget.getContent();
            if (content != null) {
                return this.setHiddenWidget(schema);
            }
            return schema;
        }
        Mapper uiMapper = UiSchemaConstants.getUiMappers().get(widget.getWidgetType());
        if (uiMapper != null) {
            uiMapper.processWidget(widget, schema, hasVisible);
        } else {
            NamedThing content = widget.getContent();
            if (content instanceof Properties) {
                return this.setHiddenWidget(schema);
            }
            hasVisible[0] = true;
        }
        String placeholder = (String)widget.getConfigurationValue("widget.conf.placeholder");
        if (placeholder != null) {
            schema.put("ui:placeholder", placeholder);
        }
        return this.addTriggerTWidget(widget, schema);
    }

    private ObjectNode addTriggerTWidget(Widget widget, ObjectNode schema) {
        ArrayNode jsonNodes = schema.arrayNode();
        if (widget.isCallAfter()) {
            jsonNodes.add(UiSchemaGenerator.fromUpperCaseToCamel(PropertyTrigger.AFTER.name()));
        }
        if (widget.isCallBeforeActivate()) {
            jsonNodes.add(UiSchemaGenerator.fromUpperCaseToCamel(PropertyTrigger.BEFORE_ACTIVE.name()));
        }
        if (widget.isCallBeforePresent()) {
            jsonNodes.add(UiSchemaGenerator.fromUpperCaseToCamel(PropertyTrigger.BEFORE_PRESENT.name()));
        }
        if (widget.isCallValidate()) {
            jsonNodes.add(UiSchemaGenerator.fromUpperCaseToCamel(PropertyTrigger.VALIDATE.name()));
        }
        if (jsonNodes.size() != 0) {
            schema.set("ui:trigger", (JsonNode)jsonNodes);
        }
        return schema;
    }

    private static String fromUpperCaseToCamel(String upperCase) {
        String[] tokens;
        StringBuilder builder = new StringBuilder();
        for (String token : tokens = upperCase.toLowerCase().split("_")) {
            builder.append(StringUtils.capitalize((String)token));
        }
        return StringUtils.uncapitalize((String)builder.toString());
    }

    private List<JsonWidget> listTypedWidget(Form form) {
        ArrayList<JsonWidget> results = new ArrayList<JsonWidget>();
        if (form != null) {
            for (Widget widget : form.getWidgets()) {
                NamedThing content = widget.getContent();
                if (!(content instanceof Property) && !(content instanceof Properties) && !(content instanceof Form) && !(content instanceof PresentationItem)) continue;
                results.add(new JsonWidget(widget, form));
            }
        }
        return results;
    }

    private ObjectNode setHiddenWidget(ObjectNode schema) {
        schema.put("ui:widget", "hidden");
        return schema;
    }
}

