/*
 * Decompiled with CFR 0.152.
 */
package org.talend.java.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;

public class ClosableLRUMap<K, V>
extends LinkedHashMap<K, V> {
    protected final int _maxEntries;

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean removeOldest;
        boolean bl = removeOldest = this.size() > this._maxEntries;
        if (removeOldest) {
            this.closeValue(eldest.getValue());
        }
        return removeOldest;
    }

    public ClosableLRUMap(int initialEntries, int maxEntries) {
        super(initialEntries, 0.8f, true);
        this._maxEntries = maxEntries;
    }

    @Override
    public V remove(Object key) {
        Object value = this.get(key);
        this.closeValue(value);
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.closeValue(value);
        return super.remove(key, value);
    }

    @Override
    public void clear() {
        for (Object value : this.values()) {
            this.closeValue(value);
        }
        super.clear();
    }

    private void closeValue(Object value) {
        if (value instanceof AutoCloseable) {
            try {
                ((AutoCloseable)value).close();
            }
            catch (Exception e) {
                new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
    }
}

