/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro;

import java.util.Set;

public class NameUtil {
    public static String correct(String name, int nameIndex, Set<String> previousNames) {
        if (name == null || name.isEmpty() || previousNames == null) {
            return name;
        }
        StringBuilder str = new StringBuilder();
        int underLineCount = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' && i != 0) {
                str.append(c);
                continue;
            }
            if (c == '_') {
                str.append(c);
                ++underLineCount;
                continue;
            }
            str.append('_');
            ++underLineCount;
        }
        String result = null;
        result = underLineCount > name.length() / 2 ? "Column" + nameIndex : str.toString();
        return NameUtil.getUniqueName(result, previousNames);
    }

    private static String getUniqueName(String name, Set<String> previousNames) {
        boolean allIsDifferent = false;
        int index = 0;
        String currentName = name;
        while (!allIsDifferent) {
            allIsDifferent = true;
            if (previousNames.contains(currentName)) {
                allIsDifferent = false;
            }
            if (allIsDifferent) continue;
            currentName = currentName + ++index;
        }
        return currentName;
    }
}

