/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.converter;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.talend.daikon.avro.converter.WrappedIterator;
import org.talend.daikon.java8.Function;

public class WrappedSet<InT, OutT>
extends AbstractSet<OutT> {
    private final Set<InT> mWrapped;
    private final Function<InT, OutT> mInFunction;
    private final Function<OutT, InT> mOutFunction;

    WrappedSet(Set<InT> wrapped, Function<InT, OutT> inFunction, Function<OutT, InT> outFunction) {
        this.mWrapped = wrapped;
        this.mInFunction = inFunction;
        this.mOutFunction = outFunction;
    }

    @Override
    public Iterator<OutT> iterator() {
        return new WrappedIterator<InT, OutT>(this.mWrapped.iterator(), this.mInFunction);
    }

    @Override
    public int size() {
        return this.mWrapped.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.mWrapped.contains(this.mOutFunction.apply(o));
    }
}

