/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.converter.string;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroUtils;
import org.talend.daikon.avro.converter.string.StringConverter;

public class StringTimestampConverter
extends StringConverter<Long> {
    private static final Schema TIMESTAMP_SCHEMA = AvroUtils._logicalTimestamp();
    public static final String DEFAULT_PATTERN = "dd-MM-yyyy hh:mm:ss:SSS";
    private final DateFormat dateFormat;

    public StringTimestampConverter() {
        this(DEFAULT_PATTERN);
    }

    public StringTimestampConverter(String datePattern) {
        if (datePattern == null) {
            throw new IllegalArgumentException("Date pattern is missed");
        }
        this.dateFormat = new SimpleDateFormat(datePattern);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public Schema getSchema() {
        return TIMESTAMP_SCHEMA;
    }

    @Override
    public String convertToDatum(Long value) {
        Date timestamp = new Date(value);
        return this.dateFormat.format(timestamp);
    }

    @Override
    public Long convertToAvro(String value) {
        try {
            Date timestamp = this.dateFormat.parse(value);
            return timestamp.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Input string doesn't match specified date pattern", e);
        }
    }
}

