/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.visitor.path;

import org.talend.daikon.avro.visitor.path.TraversalPathPrinter;

public class JsonPathPrinter
implements TraversalPathPrinter {
    private final StringBuffer buffer = new StringBuffer();
    private final JsonPathStyle style;

    public JsonPathPrinter() {
        this(JsonPathStyle.DOT);
    }

    public JsonPathPrinter(JsonPathStyle style) {
        this.style = style;
    }

    @Override
    public void root() {
        this.buffer.append('$');
    }

    @Override
    public void append(String name, int position) {
        this.style.notation.append(this.buffer, name);
    }

    @Override
    public void arrayIndex(int index) {
        this.buffer.append('[');
        this.buffer.append(index);
        this.buffer.append(']');
    }

    @Override
    public void mapEntry(String key) {
        this.style.notation.append(this.buffer, key);
    }

    public String toString() {
        return this.buffer.toString();
    }

    private static final class BracketNotation
    implements JsonPathNotation {
        private BracketNotation() {
        }

        @Override
        public void append(StringBuffer buffer, String name) {
            buffer.append("['");
            buffer.append(name);
            buffer.append("']");
        }
    }

    private static final class DotNotation
    implements JsonPathNotation {
        private DotNotation() {
        }

        @Override
        public void append(StringBuffer buffer, String name) {
            buffer.append('.');
            buffer.append(name);
        }
    }

    private static interface JsonPathNotation {
        public void append(StringBuffer var1, String var2);
    }

    public static enum JsonPathStyle {
        DOT(new DotNotation()),
        BRACKETS(new BracketNotation());

        public final JsonPathNotation notation;

        private JsonPathStyle(JsonPathNotation notation) {
            this.notation = notation;
        }
    }
}

