/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.visitor.path;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.avro.Schema;
import org.talend.daikon.avro.visitor.path.TraversalPathPrinter;
import org.talend.daikon.avro.visitor.path.XpathPrinter;

public class TraversalPath
implements Iterable<TraversalPathElement>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final LinkedList<TraversalPathElement> elements;
    private final String path;

    private TraversalPath(LinkedList<TraversalPathElement> elements) {
        this.elements = elements;
        XpathPrinter printer = new XpathPrinter();
        this.path = this.toString(printer);
    }

    public static TraversalPath create(Schema schema) {
        RootPathElement root = new RootPathElement(schema);
        return new TraversalPath(new LinkedList<TraversalPathElement>(Collections.singletonList(root)));
    }

    public TraversalPath append(String name) {
        Schema schema = this.last().getSchema();
        Schema.Field field = schema.getField(name);
        return this.append(name, field.pos(), field.schema());
    }

    public TraversalPath append(int position) {
        Schema schema = this.last().getSchema();
        Schema.Field field = (Schema.Field)schema.getFields().get(position);
        return this.append(field.name(), position, field.schema());
    }

    public TraversalPath append(TraversalPathElement element) {
        LinkedList<TraversalPathElement> newList = new LinkedList<TraversalPathElement>(this.elements);
        newList.add(element);
        return new TraversalPath(newList);
    }

    public TraversalPath append(String name, int position, Schema schema) {
        return this.append(new TraversalPathElement(name, position, schema));
    }

    public TraversalPath appendArrayIndex(int index) {
        TraversalPathElement array = this.last();
        return this.append(new ArrayItemPathElement(array, index));
    }

    public TraversalPath appendMapEntry(String key) {
        TraversalPathElement map = this.last();
        return this.append(new MapEntryPathElement(map, key));
    }

    @Override
    public Iterator<TraversalPathElement> iterator() {
        return this.elements.iterator();
    }

    public Iterator<TraversalPathElement> descendingIterator() {
        return this.elements.descendingIterator();
    }

    public TraversalPathElement last() {
        return this.elements.getLast();
    }

    public TraversalPathElement root() {
        return this.elements.getFirst();
    }

    public String toString() {
        return this.path;
    }

    public String toString(TraversalPathPrinter printer) {
        for (TraversalPathElement element : this.elements) {
            element.print(printer);
        }
        return printer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraversalPath that = (TraversalPath)o;
        return this.path != null ? this.path.equals(that.path) : that.path == null;
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public static class MapEntryPathElement
    extends TraversalPathElement {
        private static final long serialVersionUID = 1L;
        private final String key;

        MapEntryPathElement(TraversalPathElement mapPath, String key) {
            super(mapPath.name, mapPath.position, mapPath.schema.getValueType());
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public void print(TraversalPathPrinter printer) {
            printer.mapEntry(this.key);
        }
    }

    public static class ArrayItemPathElement
    extends TraversalPathElement {
        private static final long serialVersionUID = 1L;
        private final int index;

        ArrayItemPathElement(TraversalPathElement arrayPath, int index) {
            super(arrayPath.name, arrayPath.position, arrayPath.schema.getElementType());
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void print(TraversalPathPrinter printer) {
            printer.arrayIndex(this.index);
        }
    }

    public static class RootPathElement
    extends TraversalPathElement {
        private static final long serialVersionUID = 1L;
        private static final String ROOT = "";

        public RootPathElement(Schema schema) {
            super(ROOT, 0, schema);
        }

        @Override
        public void print(TraversalPathPrinter printer) {
            printer.root();
        }
    }

    public static class TraversalPathElement
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final int position;
        private final Schema schema;

        TraversalPathElement(String name, int position, Schema schema) {
            this.name = name;
            this.position = position;
            this.schema = schema;
        }

        public String getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void print(TraversalPathPrinter printer) {
            printer.append(this.name, this.position);
        }
    }
}

