/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.visitor.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.visitor.path.TraversalPath;
import org.talend.daikon.avro.visitor.record.AbstractVisitableStructure;
import org.talend.daikon.avro.visitor.record.RecordVisitor;
import org.talend.daikon.avro.visitor.record.VisitableStructure;
import org.talend.daikon.avro.visitor.record.VisitableStructureFactory;

public class VisitableRecord
extends AbstractVisitableStructure<IndexedRecord> {
    public VisitableRecord(IndexedRecord record) {
        this(record, TraversalPath.create(record.getSchema()));
    }

    VisitableRecord(IndexedRecord value, TraversalPath path) {
        super(value, path);
    }

    @Override
    public void accept(RecordVisitor visitor) {
        visitor.visit(this);
    }

    public Iterator<VisitableStructure> getFields() {
        Schema schema = ((IndexedRecord)this.getValue()).getSchema();
        ArrayList<VisitableStructure> fields = new ArrayList<VisitableStructure>(schema.getFields().size());
        for (Schema.Field field : schema.getFields()) {
            TraversalPath fieldPath = this.getPath().append(field.name(), field.pos(), field.schema());
            VisitableStructure node = VisitableStructureFactory.createVisitableField(field, (IndexedRecord)this.getValue(), fieldPath);
            fields.add(node);
        }
        return Collections.unmodifiableList(fields).iterator();
    }
}

