/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.i18n.tag;

import org.talend.daikon.i18n.I18nMessages;
import org.talend.daikon.i18n.TranslatableImpl;
import org.talend.daikon.i18n.tag.Tag;
import org.talend.daikon.i18n.tag.TagUtils;

public class TagImpl
extends TranslatableImpl
implements Tag {
    private final String value;
    private Tag parentTag;
    private boolean formatterSet = false;

    public TagImpl(String name) {
        this(name, null);
    }

    public TagImpl(String name, Tag parentTag) {
        this(name, parentTag, null);
    }

    public TagImpl(String name, Tag parentTag, I18nMessages i18nMessages) {
        this.value = name;
        this.parentTag = parentTag;
        this.setI18nMessageFormatter(i18nMessages);
    }

    @Override
    public void setI18nMessageFormatter(I18nMessages i18nMessages) {
        if (!this.formatterSet && i18nMessages != null) {
            super.setI18nMessageFormatter(i18nMessages);
            this.formatterSet = true;
        }
    }

    public String toString() {
        return TagUtils.getTranslatedPathToRoot(this);
    }

    @Override
    public String getTranslatedValue() {
        String fullTagName = "tag." + this.getValue();
        String value = this.getI18nMessage(fullTagName, new Object());
        return fullTagName.equals(value) ? this.getValue() : value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Tag getParentTag() {
        return this.parentTag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.parentTag == null ? 0 : this.parentTag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagImpl other = (TagImpl)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.parentTag == null ? other.parentTag != null : !this.parentTag.equals(other.parentTag));
    }
}

