/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.NamedThing;
import org.talend.daikon.definition.Definition;
import org.talend.daikon.definition.service.DefinitionRegistryService;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.AnyPropertyVisitor;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesDynamicMethodHelper;
import org.talend.daikon.properties.PropertiesImpl;
import org.talend.daikon.properties.PropertiesVisitor;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.PropertyFactory;

public class ReferenceProperties<T extends Properties>
extends PropertiesImpl {
    private static final long serialVersionUID = -5424441531219285811L;
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceProperties.class);
    public final Property<String> referenceDefinitionName = PropertyFactory.newProperty("referenceDefinitionName");
    private T reference;

    public ReferenceProperties(String name, String referenceDefinitionName) {
        super(name);
        this.referenceDefinitionName.setValue(referenceDefinitionName);
    }

    public void setReference(Properties prop) {
        this.reference = prop;
    }

    public T getReference() {
        return this.reference;
    }

    @Override
    protected boolean acceptUninitializedField(Field f) {
        if (super.acceptUninitializedField(f)) {
            return true;
        }
        return "reference".equals(f.getName());
    }

    @Override
    protected void acceptForAllProperties(AnyPropertyVisitor visitor, Set<Properties> visited) {
        super.acceptForAllProperties(visitor, visited);
        if (this.reference != null) {
            this.acceptForProperty(visitor, visited, (NamedThing)this.reference);
        }
    }

    public static void resolveReferenceProperties(Iterable<? extends Properties> properties, DefinitionRegistryService definitionRegistry) {
        ReferenceProperties.resolveReferenceProperties(properties, definitionRegistry, false);
    }

    public static void resolveReferenceProperties(Iterable<? extends Properties> properties, DefinitionRegistryService definitionRegistry, boolean callAfterCallback) {
        HashMap<String, Properties> def2PropsMap = new HashMap<String, Properties>();
        for (Properties properties2 : properties) {
            Iterable<Definition> allDefs = definitionRegistry.getDefinitionForPropertiesType(properties2.getClass());
            for (Definition def : allDefs) {
                def2PropsMap.put(def.getName(), properties2);
            }
        }
        ReferenceProperties.resolveReferenceProperties(def2PropsMap, callAfterCallback);
    }

    public static void resolveReferenceProperties(Map<String, Properties> propertiesMap) {
        ReferenceProperties.resolveReferenceProperties(propertiesMap, false);
    }

    public static void resolveReferenceProperties(final Map<String, Properties> propertiesMap, final boolean callAfterCallback) {
        for (Map.Entry<String, Properties> entry : propertiesMap.entrySet()) {
            Properties theProperties = entry.getValue();
            theProperties.accept(new PropertiesVisitor(){

                @Override
                public void visit(Properties properties, Properties parent) {
                    if (properties instanceof ReferenceProperties) {
                        ReferenceProperties referenceProperties = (ReferenceProperties)properties;
                        Properties theReference = (Properties)propertiesMap.get(referenceProperties.referenceDefinitionName.getValue());
                        if (theReference != null) {
                            referenceProperties.setReference(theReference);
                            if (callAfterCallback) {
                                try {
                                    PropertiesDynamicMethodHelper.afterReference(parent, referenceProperties);
                                }
                                catch (Throwable e) {
                                    throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, e);
                                }
                            }
                        } else {
                            LOG.debug("failed to find a reference object for ReferenceProperties[" + referenceProperties.getName() + "] with definition [" + referenceProperties.referenceDefinitionName.getValue() + "] and with parent type [" + (parent != null ? parent.getClass().getName() : "null") + "]");
                        }
                    }
                }
            }, null);
        }
    }
}

