/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.presentation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.strings.ToStringIndent;
import org.talend.daikon.strings.ToStringIndentUtil;

public class Widget
implements ToStringIndent {
    public static final String DEFAULT_WIDGET_TYPE = "widget.type.default";
    public static final String SCHEMA_EDITOR_WIDGET_TYPE = "widget.type.schema.editor";
    public static final String SCHEMA_REFERENCE_WIDGET_TYPE = "widget.type.schema.reference";
    public static final String NAME_SELECTION_AREA_WIDGET_TYPE = "widget.type.name.selection.area";
    public static final String NAME_SELECTION_REFERENCE_WIDGET_TYPE = "widget.type.name.selection.widget";
    public static final String COMPONENT_REFERENCE_WIDGET_TYPE = "widget.type.component.reference";
    public static final String BUTTON_WIDGET_TYPE = "widget.type.button";
    public static final String TABLE_WIDGET_TYPE = "widget.type.table";
    public static final String HIDDEN_TEXT_WIDGET_TYPE = "widget.type.hidden.text";
    public static final String FILE_WIDGET_TYPE = "widget.type.file";
    public static final String DIRECTORY_WIDGET_TYPE = "widget.type.directory";
    public static final String ENUMERATION_WIDGET_TYPE = "widget.type.enumeration";
    public static final String TEXT_AREA_WIDGET_TYPE = "widget.type.textArea";
    public static final String RADIO_WIDGET_TYPE = "widget.type.radio";
    public static final String SELECT_WIDGET_TYPE = "widget.type.select";
    public static final String SELECT_WIZARD_WIDGET_TYPE = "widget.type.select.wizard";
    public static final String EXTERNAL_LINK_WIDGET_TYPE = "widget.type.external.link";
    public static final String DATALIST_WIDGET_TYPE = "widget.type.datalist";
    public static final String JSON_TABLE_WIDGET_TYPE = "widget.type.jsonTable";
    public static final String MULTIPLE_VALUE_SELECTOR_WIDGET_TYPE = "widget.type.listview";
    public static final String NESTED_PROPERTIES = "widget.type.nestedProperties";
    public static final String NESTED_PROPERTIES_TYPE_OPTION = "type";
    public static final String UNCOLLAPSIBLE_NESTED_PROPERTIES = "widget.type.uncollapsibleNestedProperties";
    public static final String COLUMNS_PROPERTIES = "widget.type.columns";
    public static final String CODE_WIDGET_TYPE = "widget.type.code";
    public static final String CODE_SYNTAX_WIDGET_CONF = "language";
    public static final String READ_ONLY_WIDGET_CONF = "widget.conf.readonly";
    public static final String AUTO_FOCUS_WIDGET_CONF = "widget.conf.autofocus";
    public static final String HIDE_TOOLBAR_WIDGET_CONF = "widget.conf.hide.toolbar";
    public static final String PLACEHOLDER_WIDGET_CONF = "widget.conf.placeholder";
    private int row;
    private int order;
    private boolean hidden;
    private String widgetType = "widget.type.default";
    private boolean longRunning;
    private boolean deemphasize;
    private boolean callBeforeActivate;
    private boolean callBeforePresent;
    private boolean callValidate;
    private boolean callAfter;
    private NamedThing content;
    private Map<String, Object> configurationValues = new HashMap<String, Object>();

    public Widget(NamedThing content) {
        this.content = content;
    }

    public static Widget widget(NamedThing content) {
        return new Widget(content);
    }

    public NamedThing getContent() {
        return this.content;
    }

    public int getRow() {
        return this.row;
    }

    public Widget setRow(int row) {
        this.row = row;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public Widget setOrder(int order) {
        this.order = order;
        return this;
    }

    public Widget setHidden(boolean hidden) {
        this.hidden = hidden;
        if (this.content != null && this.content instanceof Form) {
            ((Form)this.content).setHidden(hidden);
        } else if (this.content != null && this.content instanceof Property) {
            Property prop = (Property)this.content;
            if (hidden) {
                prop.addFlag(Property.Flags.HIDDEN);
            } else {
                prop.removeFlag(Property.Flags.HIDDEN);
            }
        }
        return this;
    }

    public Widget setHidden() {
        return this.setHidden(true);
    }

    public Widget setVisible(boolean visible) {
        return this.setHidden(!visible);
    }

    public Widget setVisible() {
        return this.setVisible(true);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Widget setHidden(Property<Boolean> hidden) {
        return this.setHidden(hidden.getValue());
    }

    public boolean isVisible() {
        return !this.hidden;
    }

    public Widget setVisible(Property<Boolean> visible) {
        return this.setHidden(visible.getValue() == false);
    }

    public String getWidgetType() {
        return this.widgetType;
    }

    public Widget setWidgetType(String widgetType) {
        this.widgetType = widgetType;
        return this;
    }

    public boolean isLongRunning() {
        return this.longRunning;
    }

    public Widget setLongRunning(boolean longRunning) {
        this.longRunning = longRunning;
        return this;
    }

    public boolean isDeemphasize() {
        return this.deemphasize;
    }

    public Widget setDeemphasize(boolean deemphasize) {
        this.deemphasize = deemphasize;
        return this;
    }

    public boolean isCallBeforeActivate() {
        return this.callBeforeActivate;
    }

    public void setCallBefore(boolean callBefore) {
        if (this.widgetType.equals(SCHEMA_REFERENCE_WIDGET_TYPE) || this.widgetType.equals(NAME_SELECTION_REFERENCE_WIDGET_TYPE)) {
            this.callBeforeActivate = callBefore;
            this.callBeforePresent = !callBefore;
        } else {
            this.callBeforePresent = callBefore;
            this.callBeforeActivate = !callBefore;
        }
    }

    public boolean isCallBeforePresent() {
        return this.callBeforePresent;
    }

    public boolean isCallValidate() {
        return this.callValidate;
    }

    public void setCallValidate(boolean callValidate) {
        this.callValidate = callValidate;
    }

    public boolean isCallAfter() {
        return this.callAfter;
    }

    public void setCallAfter(boolean callAfter) {
        this.callAfter = callAfter;
    }

    public boolean isReadonly() {
        return Boolean.valueOf(String.valueOf(this.getConfigurationValue(READ_ONLY_WIDGET_CONF)));
    }

    public Widget setReadonly(boolean readonly) {
        this.setConfigurationValue(READ_ONLY_WIDGET_CONF, readonly);
        return this;
    }

    public boolean isAutoFocus() {
        return Boolean.valueOf(String.valueOf(this.getConfigurationValue(AUTO_FOCUS_WIDGET_CONF)));
    }

    public Widget setAutoFocus(boolean autoFocus) {
        this.setConfigurationValue(AUTO_FOCUS_WIDGET_CONF, autoFocus);
        return this;
    }

    public Object getConfigurationValue(String key) {
        return this.configurationValues.get(key);
    }

    public Widget setConfigurationValue(String key, Object value) {
        this.configurationValues.put(key, value);
        return this;
    }

    public String toString() {
        return this.toStringIndent(0);
    }

    @Override
    public String toStringIndent(int indent) {
        List<?> values;
        StringBuilder sb = new StringBuilder();
        String is = ToStringIndentUtil.indentString(indent);
        sb.append(is + "Widget: " + this.getWidgetType() + " " + this.getRow() + "/" + this.getOrder() + " ");
        NamedThing n = this.getContent();
        if (n instanceof Form) {
            sb.append("Form: ");
        }
        sb.append(n.getName());
        if (n instanceof Form) {
            sb.append(" (props: " + ((Form)n).getProperties().getName() + ")");
        }
        if (n instanceof Property && (values = ((Property)n).getPossibleValues()) != null) {
            sb.append(" Values: " + values);
        }
        if (this.isCallBeforeActivate()) {
            sb.append(" CALL_BEFORE_ACTIVATE");
        }
        if (this.isCallBeforePresent()) {
            sb.append(" CALL_BEFORE_PRESENT");
        }
        if (this.isCallAfter()) {
            sb.append(" CALL_AFTER");
        }
        if (this.isCallValidate()) {
            sb.append(" CALL_VALIDATE");
        }
        return sb.toString();
    }
}

