/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.talend.daikon.properties.property.EnumListProperty;
import org.talend.daikon.properties.property.EnumProperty;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.properties.property.SchemaProperty;
import org.talend.daikon.properties.property.StringProperty;

public class PropertyFactory {
    public static TypeLiteral<List<String>> LIST_STRING_ELEMENT = new TypeLiteral<List<String>>(){};

    private PropertyFactory() {
    }

    public static StringProperty newProperty(String name) {
        return PropertyFactory.newString(name);
    }

    public static StringProperty newString(String name) {
        return new StringProperty(name);
    }

    public static StringProperty newString(String name, String initialValue) {
        StringProperty property = PropertyFactory.newString(name);
        property.setValue(initialValue);
        return property;
    }

    public static StringProperty newString(String name, String initialValue, String defaultValue) {
        StringProperty property = PropertyFactory.newString(name);
        property.setValue(initialValue);
        property.setDefaultValue(defaultValue);
        return property;
    }

    public static Property<Integer> newInteger(String name) {
        return new Property<Integer>(Integer.class, name);
    }

    public static Property<Integer> newInteger(String name, String initialValue) {
        return PropertyFactory.newInteger(name).setValue(Integer.valueOf(initialValue));
    }

    public static Property<Integer> newInteger(String name, Integer initialValue) {
        return PropertyFactory.newInteger(name).setValue(initialValue);
    }

    public static Property<Double> newDouble(String name) {
        return new Property<Double>(new TypeLiteral<Double>(){}, name);
    }

    public static Property<Double> newDouble(String name, String initialValue) {
        return PropertyFactory.newDouble(name).setValue(Double.valueOf(initialValue));
    }

    public static Property<Double> newDouble(String name, Double initialValue) {
        return PropertyFactory.newDouble(name).setValue(initialValue);
    }

    public static Property<Float> newFloat(String name) {
        return new Property<Float>(new TypeLiteral<Float>(){}, name);
    }

    public static Property<Float> newFloat(String name, String initialValue) {
        return PropertyFactory.newFloat(name).setValue(Float.valueOf(initialValue));
    }

    public static Property<Float> newFloat(String name, Float initialValue) {
        return PropertyFactory.newFloat(name).setValue(initialValue);
    }

    public static Property<Boolean> newBoolean(String name) {
        return new Property<Boolean>(new TypeLiteral<Boolean>(){}, name).setValue(Boolean.FALSE);
    }

    public static Property<Boolean> newBoolean(String name, String initialValue) {
        return PropertyFactory.newBoolean(name).setValue(Boolean.valueOf(initialValue));
    }

    public static Property<Boolean> newBoolean(String name, Boolean initialValue) {
        return PropertyFactory.newBoolean(name).setValue(initialValue);
    }

    public static Property<Date> newDate(String name) {
        return new Property<Date>(new TypeLiteral<Date>(){}, name);
    }

    public static Property<List<String>> newStringList(String name) {
        return new Property<List<String>>(LIST_STRING_ELEMENT, name).setValue(new ArrayList());
    }

    public static <T> Property<List<T>> newList(String name, Class<T> zeListElementType) {
        TypeLiteral literalType = new TypeLiteral<List<T>>(){};
        return new Property(literalType, name).setValue(new ArrayList());
    }

    public static <T extends Enum<T>> EnumProperty<T> newEnum(String name, Class<T> zeEnumType) {
        return new EnumProperty<T>(zeEnumType, name);
    }

    public static <T extends Enum<T>> EnumListProperty<T> newEnumList(String name, TypeLiteral<List<T>> type) {
        return new EnumListProperty<T>(type, name);
    }

    public static Property<Schema> newSchema(String name) {
        return new SchemaProperty(name);
    }

    public static <T> Property<T> newProperty(Class<T> type, String name) {
        return new Property<T>(type, name);
    }

    public static <T> Property<T> newProperty(Class<T> type, String name, String title) {
        return new Property<T>(type, name).setTitle(title);
    }

    public static <T> Property<T> newProperty(TypeLiteral<T> type, String name) {
        return new Property<T>(type, name);
    }

    public static <T> Property<T> newProperty(TypeLiteral<T> type, String name, String title) {
        return new Property<T>(type, name).setTitle(title);
    }
}

