/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.property;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.talend.daikon.NamedThing;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.security.CryptoHelper;

public class StringProperty
extends Property<String> {
    private static final long serialVersionUID = -7464790471464008148L;
    private List<NamedThing> possibleValues2;

    public StringProperty(String name) {
        super(String.class, name);
    }

    StringProperty(String type, String name) {
        super(type, name);
    }

    public Property<String> setPossibleNamedThingValues(List<NamedThing> possibleValues) {
        this.possibleValues2 = possibleValues;
        ArrayList<String> realPossibleValues = new ArrayList<String>();
        for (NamedThing nt : this.possibleValues2) {
            realPossibleValues.add(nt.getName());
        }
        super.setPossibleValues(realPossibleValues);
        return this;
    }

    @Override
    @JsonIgnore
    public Property<String> setPossibleValues(List<?> possibleValues) {
        if (possibleValues != null && !possibleValues.isEmpty() && possibleValues.get(0) instanceof NamedThing) {
            this.setPossibleNamedThingValues(possibleValues);
        } else {
            super.setPossibleValues(possibleValues);
        }
        return this;
    }

    @Override
    public String getPossibleValuesDisplayName(Object possibleValue) {
        String possibleValueDisplayName;
        String string = possibleValueDisplayName = possibleValue == null ? "null" : possibleValue.toString();
        if (!this.isAPossibleValue(possibleValue)) {
            throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_ARGUMENT, ExceptionContext.build().put("argument", (Object)"possibleValues").put("value", possibleValue));
        }
        if (this.possibleValues2 != null && !this.possibleValues2.isEmpty()) {
            for (NamedThing nt : this.possibleValues2) {
                if (possibleValue == null || !possibleValue.equals(nt.getName())) continue;
                possibleValueDisplayName = nt.getDisplayName() != null ? nt.getDisplayName() : nt.getName();
                break;
            }
        } else {
            possibleValueDisplayName = super.getPossibleValuesDisplayName(possibleValue);
        }
        return possibleValueDisplayName;
    }

    @Override
    public void encryptStoredValue(boolean encrypt) {
        if (this.isFlag(Property.Flags.ENCRYPT)) {
            String value = (String)this.getStoredValue();
            CryptoHelper ch = new CryptoHelper("99ZwBDt1L9yMX2ApJx fnv94o99OeHbCGuIHTy22 V9O6cZ2i374fVjdV76VX9g49DG1r3n90hT5c1");
            if (encrypt) {
                this.setStoredValue(ch.encrypt(value));
            } else {
                this.setStoredValue(ch.decrypt(value));
            }
        }
    }
}

