/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.sandbox;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.sandbox.properties.ClassLoaderIsolatedSystemProperties;
import org.talend.daikon.sandbox.properties.StandardPropertiesStrategyFactory;

public class SandboxedInstance
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SandboxedInstance.class);
    protected ClassLoader previousContextClassLoader;
    protected Thread isolatedThread;
    protected boolean useCurrentJvmProperties;
    private ClassLoader sandboxClassLoader;
    private String classToInstanciate;
    private Object instance;
    private boolean isClosed;
    private final boolean reusableClassLoader;

    SandboxedInstance(String classToInstanciate, boolean useCurrentJvmProperties, ClassLoader sandboxClassLoader, boolean reusableClassLoader) {
        this.classToInstanciate = classToInstanciate;
        this.useCurrentJvmProperties = useCurrentJvmProperties;
        this.sandboxClassLoader = sandboxClassLoader;
        this.reusableClassLoader = reusableClassLoader;
    }

    @Override
    public void close() {
        this.instance = null;
        if (this.isolatedThread != null) {
            this.isolatedThread.setContextClassLoader(this.previousContextClassLoader);
        }
        if (!this.reusableClassLoader) {
            ClassLoaderIsolatedSystemProperties.getInstance().stopIsolateClassLoader(this.sandboxClassLoader);
            if (this.sandboxClassLoader instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.sandboxClassLoader)).close();
                }
                catch (Exception e) {
                    TalendRuntimeException.createUnexpectedException((Throwable)e);
                }
            }
        }
        this.sandboxClassLoader = null;
        this.previousContextClassLoader = null;
        this.isolatedThread = null;
        this.isClosed = true;
    }

    public Object getInstance() {
        if (this.isClosed) {
            throw new IllegalStateException("Object closed");
        }
        if (this.isolatedThread == null) {
            this.isolatedThread = Thread.currentThread();
            this.previousContextClassLoader = this.isolatedThread.getContextClassLoader();
            Properties isolatedProperties = this.useCurrentJvmProperties ? ClassLoaderIsolatedSystemProperties.getInstance().getDefaultSystemProperties() : StandardPropertiesStrategyFactory.create().getStandardProperties();
            ClassLoaderIsolatedSystemProperties.getInstance().startIsolateClassLoader(this.sandboxClassLoader, isolatedProperties);
            this.isolatedThread.setContextClassLoader(this.sandboxClassLoader);
            LOGGER.debug("creating instance of class '" + this.classToInstanciate + "...'");
            try {
                Class<?> clazz = this.sandboxClassLoader.loadClass(this.classToInstanciate);
                this.instance = clazz.newInstance();
                LOGGER.debug("done creating class '" + this.classToInstanciate + "'");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
        return this.instance;
    }

    public ClassLoader getSandboxClassLoader() {
        return this.sandboxClassLoader;
    }
}

