/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.sandbox.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderIsolatedSystemProperties
extends Properties {
    public static final String ORG_OPS4J_PAX_URL_MVN_LOCAL_REPOSITORY = "org.ops4j.pax.url.mvn.localRepository";
    private static final Map<ClassLoader, Properties> classLoaderProperties = new HashMap<ClassLoader, Properties>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderIsolatedSystemProperties.class);
    private static ClassLoaderIsolatedSystemProperties instance;
    private final Properties defaultSystemProperties;

    private ClassLoaderIsolatedSystemProperties(Properties defaultSystemProperties) {
        this.defaultSystemProperties = defaultSystemProperties;
    }

    public static ClassLoaderIsolatedSystemProperties getInstance() {
        if (instance == null) {
            instance = new ClassLoaderIsolatedSystemProperties(System.getProperties());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIsolateClassLoader(ClassLoader classloader, Properties theClassLoaderProperties) {
        Map<ClassLoader, Properties> map = classLoaderProperties;
        synchronized (map) {
            if (theClassLoaderProperties == this) {
                throw new IllegalArgumentException("Cannot accept instance " + classLoaderProperties.getClass().getName() + " as parameter.");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Isolating ClassLoader '" + classloader.toString() + "'");
            }
            Properties clonedProperties = (Properties)theClassLoaderProperties.clone();
            if (this.defaultSystemProperties.containsKey(ORG_OPS4J_PAX_URL_MVN_LOCAL_REPOSITORY)) {
                clonedProperties.setProperty(ORG_OPS4J_PAX_URL_MVN_LOCAL_REPOSITORY, this.defaultSystemProperties.getProperty(ORG_OPS4J_PAX_URL_MVN_LOCAL_REPOSITORY));
            }
            classLoaderProperties.put(classloader, clonedProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIsolateClassLoader(ClassLoader classLoader) {
        Map<ClassLoader, Properties> map = classLoaderProperties;
        synchronized (map) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stops isolating ClassLoader '" + classLoader.toString() + "'");
            }
            classLoaderProperties.remove(classLoader);
        }
    }

    public boolean isIsolated(ClassLoader classloader) {
        return classLoaderProperties.containsKey(classloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getThreadProperties(Thread thread) {
        Map<ClassLoader, Properties> map = classLoaderProperties;
        synchronized (map) {
            Properties currentThreadProperties;
            if (thread == null) {
                return this.defaultSystemProperties;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Requesting for thread system properties '" + thread.getName() + "'");
            }
            if ((currentThreadProperties = classLoaderProperties.get(thread.getContextClassLoader())) == null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Thread '" + thread.getName() + "' is not isolated. Return default properties");
                }
                return this.defaultSystemProperties;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Thread '" + thread.getName() + "' is isolated. Return thread properties (dump below).");
                LOGGER.trace(currentThreadProperties.toString());
            }
            return currentThreadProperties;
        }
    }

    public Properties getDefaultSystemProperties() {
        return this.defaultSystemProperties;
    }

    public Properties getThreadProperties() {
        return this.getThreadProperties(Thread.currentThread());
    }

    @Override
    public synchronized void putAll(Map<?, ?> map) {
        Set<Map.Entry<?, ?>> entries = map.entrySet();
        for (Map.Entry<?, ?> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.setProperty((String)key, (String)value);
    }

    @Override
    public synchronized int size() {
        return this.getThreadProperties().size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.getThreadProperties().isEmpty();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return this.getThreadProperties().keys();
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        return this.getThreadProperties().elements();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.getThreadProperties().contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.getThreadProperties().containsValue(o);
    }

    @Override
    public synchronized boolean containsKey(Object o) {
        return this.getThreadProperties().containsKey(o);
    }

    @Override
    public synchronized Object get(Object o) {
        return this.getThreadProperties().get(o);
    }

    @Override
    public synchronized Object remove(Object o) {
        return this.getThreadProperties().remove(o);
    }

    @Override
    public synchronized void clear() {
        this.getThreadProperties().clear();
    }

    @Override
    public synchronized Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized String toString() {
        return this.getThreadProperties().toString();
    }

    @Override
    public Set<Object> keySet() {
        return this.getThreadProperties().keySet();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.getThreadProperties().entrySet();
    }

    @Override
    public Collection<Object> values() {
        return this.getThreadProperties().values();
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.getThreadProperties().setProperty(key, value);
    }

    @Override
    public void load(Reader reader) throws IOException {
        this.getThreadProperties().load(reader);
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        this.getThreadProperties().load(inStream);
    }

    @Override
    @Deprecated
    public void save(OutputStream out, String comments) {
        this.getThreadProperties().save(out, comments);
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        this.getThreadProperties().store(writer, comments);
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.getThreadProperties().store(out, comments);
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException {
        this.getThreadProperties().loadFromXML(in);
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.getThreadProperties().storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.getThreadProperties().storeToXML(os, comment, encoding);
    }

    @Override
    public String getProperty(String key) {
        return this.getThreadProperties().getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getThreadProperties().getProperty(key, defaultValue);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.getThreadProperties().propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.getThreadProperties().stringPropertyNames();
    }

    @Override
    public void list(PrintStream out) {
        this.getThreadProperties().list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.getThreadProperties().list(out);
    }
}

