/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.property.Property;

public class JsonBaseTool {
    protected static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.000'Z'");
    private static final String LIST_TYPE = List.class.getName();

    protected static Class findClass(ClassLoader cl, String className) {
        Class<?> aClass = null;
        try {
            aClass = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            int lastPosition = className.lastIndexOf(".");
            if (lastPosition < 0) {
                throw new RuntimeException(e);
            }
            className = className.substring(0, lastPosition) + "$" + className.substring(lastPosition + 1);
            return JsonBaseTool.findClass(cl, className);
        }
        return aClass;
    }

    protected static boolean isListClass(String className) {
        return StringUtils.startsWith((CharSequence)className, (CharSequence)LIST_TYPE);
    }

    protected static String getListType() {
        return LIST_TYPE;
    }

    protected static String getListInnerClassName(String className) {
        return className.substring((LIST_TYPE + "<").length(), className.length() - 1);
    }

    protected static List<Property> getSubProperty(Properties cProperties) {
        Field[] allFields;
        ArrayList<Property> propertyList = new ArrayList<Property>();
        for (Field field : allFields = cProperties.getClass().getFields()) {
            if (!Property.class.isAssignableFrom(field.getType()) || Modifier.isTransient(field.getModifiers())) continue;
            try {
                propertyList.add((Property)field.get(cProperties));
            }
            catch (IllegalAccessException e) {
                throw TalendRuntimeException.createUnexpectedException((Throwable)e);
            }
        }
        return propertyList;
    }

    protected static List<Properties> getSubProperties(Properties cProperties) {
        Field[] allFields;
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        for (Field field : allFields = cProperties.getClass().getFields()) {
            if (!Properties.class.isAssignableFrom(field.getType()) || Modifier.isTransient(field.getModifiers())) continue;
            try {
                propertiesList.add((Properties)field.get(cProperties));
            }
            catch (IllegalAccessException e) {
                throw TalendRuntimeException.createUnexpectedException((Throwable)e);
            }
        }
        return propertiesList;
    }

    static {
        dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

