/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesList;
import org.talend.daikon.properties.ReferenceProperties;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.serialize.jsonschema.JsonBaseTool;

public class JsonPropertiesResolver {
    public <P extends Properties> P resolveJson(ObjectNode jsonData, P cProperties) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        List<Property> propertyList = JsonBaseTool.getSubProperty(cProperties);
        for (Property property : propertyList) {
            Object newProperty = this.getTPropertyValue(cProperties.getClass().getClassLoader(), property, jsonData.get(property.getName()));
            if (newProperty == null) continue;
            property.setValue(newProperty);
        }
        List<Properties> propertiesList = JsonBaseTool.getSubProperties(cProperties);
        for (Properties properties : propertiesList) {
            if (jsonData.get(properties.getName()) == null || ReferenceProperties.class.isAssignableFrom(properties.getClass())) continue;
            if (properties instanceof PropertiesList) {
                this.resolvePropertiesList((ArrayNode)jsonData.get(properties.getName()), (PropertiesList)properties);
                continue;
            }
            this.resolveJson((ObjectNode)jsonData.get(properties.getName()), cProperties.getProperties(properties.getName()));
        }
        return cProperties;
    }

    private <P extends Properties> void resolvePropertiesList(ArrayNode objectNode, PropertiesList<P> properties) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        ArrayList<P> subProperties = new ArrayList<P>();
        for (int i = 0; i < objectNode.size(); ++i) {
            P nestedProps = properties.getNestedPropertiesFactory().createAndInit("row" + i);
            subProperties.add(this.resolveJson((ObjectNode)objectNode.get(i), nestedProps));
        }
        properties.setRows(subProperties);
    }

    private Object getTPropertyValue(ClassLoader classLoader, Property property, JsonNode dataNode) {
        String javaType = property.getType();
        if (dataNode == null || dataNode.isNull()) {
            return null;
        }
        if (JsonBaseTool.isListClass(javaType)) {
            Class type = JsonBaseTool.findClass(classLoader, JsonBaseTool.getListInnerClassName(javaType));
            ArrayNode arrayNode = (ArrayNode)dataNode;
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                values.add(this.getValue(arrayNode.get(i), type));
            }
            return values;
        }
        return this.getValue(dataNode, JsonBaseTool.findClass(classLoader, javaType));
    }

    private Object getValue(JsonNode dataNode, Class type) {
        if (String.class.equals((Object)type)) {
            return dataNode.textValue();
        }
        if (Integer.class.equals((Object)type)) {
            return dataNode.intValue();
        }
        if (Double.class.equals((Object)type)) {
            return dataNode.numberValue();
        }
        if (Float.class.equals((Object)type)) {
            return Float.valueOf(dataNode.numberValue().floatValue());
        }
        if (Boolean.class.equals((Object)type)) {
            return dataNode.booleanValue();
        }
        if (Schema.class.equals((Object)type)) {
            if (StringUtils.isNotBlank((CharSequence)dataNode.textValue())) {
                return new Schema.Parser().parse(dataNode.textValue());
            }
            return null;
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, dataNode.textValue());
        }
        if (Date.class.equals((Object)type)) {
            try {
                return JsonBaseTool.dateFormatter.parse(dataNode.textValue());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (Long.class.equals((Object)type)) {
            return dataNode.longValue();
        }
        throw new RuntimeException("Do not support type " + type + " yet.");
    }
}

