/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.List;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesList;
import org.talend.daikon.properties.ReferenceProperties;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.property.EnumListProperty;
import org.talend.daikon.properties.property.EnumProperty;
import org.talend.daikon.properties.property.Property;
import org.talend.daikon.serialize.jsonschema.JsonBaseTool;
import org.talend.daikon.serialize.jsonschema.JsonSchemaConstants;
import org.talend.daikon.serialize.jsonschema.WidgetSpecificJsonSchemaUtils;

public class JsonSchemaGenerator {
    protected ObjectNode generateJsonSchema(Properties properties, String formName) {
        return this.processTProperties(properties, formName, true);
    }

    private ObjectNode processTProperties(Properties cProperties, String formName, boolean visible) {
        ObjectNode schema = JsonNodeFactory.instance.objectNode();
        Form form = cProperties.getPreferredForm(formName);
        this.setSchemaFieldTitle(cProperties, formName, visible, schema, form);
        this.computeSchemaType(cProperties, formName, visible, schema);
        this.traverseAllProperty(cProperties, schema, form);
        this.traverseNestedProperties(cProperties, schema, form);
        return schema;
    }

    private void computeSchemaType(Properties cProperties, String formName, boolean visible, ObjectNode schema) {
        if (cProperties instanceof PropertiesList) {
            schema.put("title", cProperties.getDisplayName());
            schema.put("minItems", ((PropertiesList)cProperties).getMinItems());
            schema.put("maxItems", ((PropertiesList)cProperties).getMaxItems());
            schema.put("type", "array");
            ObjectNode itemsObjectNode = this.processTProperties((Properties)((PropertiesList)cProperties).getDefaultProperties(), formName, visible);
            itemsObjectNode.set("default", (JsonNode)this.processDefaultValues((Properties)((PropertiesList)cProperties).getDefaultProperties()));
            schema.set("items", (JsonNode)itemsObjectNode);
        } else {
            schema.put("type", "object");
            schema.putObject("properties");
        }
    }

    private void traverseNestedProperties(Properties cProperties, ObjectNode schema, Form form) {
        List<Properties> propertiesList = JsonBaseTool.getSubProperties(cProperties);
        for (Properties properties : propertiesList) {
            String name = properties.getName();
            if (properties instanceof ReferenceProperties) {
                ReferenceProperties referenceProperties = (ReferenceProperties)properties;
                ((ObjectNode)schema.get("properties")).set(name, this.processReferenceProperties(referenceProperties));
                continue;
            }
            Widget widget = form != null ? form.getWidget(properties.getName()) : null;
            boolean isVisible = widget != null && widget.isVisible();
            String propertiesFormName = null;
            if (isVisible) {
                if (widget.getContent() instanceof Form) {
                    propertiesFormName = widget.getContent().getName();
                } else if (properties instanceof PropertiesList) {
                    propertiesFormName = properties.getForm(null).getName();
                }
            }
            ((ObjectNode)schema.get("properties")).set(name, (JsonNode)this.processTProperties(properties, propertiesFormName, isVisible));
        }
    }

    private void traverseAllProperty(Properties cProperties, ObjectNode schema, Form form) {
        List<Property> propertyList = JsonBaseTool.getSubProperty(cProperties);
        for (Property property : propertyList) {
            boolean isVisible;
            String name = property.getName();
            Widget widget = form != null ? form.getWidget(property.getName()) : null;
            boolean bl = isVisible = widget != null && widget.isVisible();
            if (isVisible && property.isRequired()) {
                this.addToRequired(schema, name);
            }
            ObjectNode propertySchema = this.processTProperty(property);
            ((ObjectNode)schema.get("properties")).set(name, (JsonNode)propertySchema);
            WidgetSpecificJsonSchemaUtils.listViewSpecific(form, property, propertySchema);
        }
    }

    private void setSchemaFieldTitle(Properties cProperties, String formName, boolean visible, ObjectNode schema, Form form) {
        if (visible) {
            if (formName != null) {
                if (form != null) {
                    schema.put("title", form.getDisplayName());
                } else {
                    schema.put("title", "");
                }
            } else {
                schema.put("title", cProperties.getDisplayName());
            }
        } else {
            schema.put("title", "");
        }
    }

    private JsonNode processReferenceProperties(ReferenceProperties<?> referenceProperties) {
        ObjectNode schema = JsonNodeFactory.instance.objectNode();
        schema.put("title", referenceProperties.getDisplayName());
        schema.put("type", "string");
        return schema;
    }

    private ObjectNode processTProperty(Property property) {
        ObjectNode schema = JsonNodeFactory.instance.objectNode();
        schema.put("title", property.getDisplayName());
        if (!property.getPossibleValues().isEmpty()) {
            if (property instanceof EnumProperty) {
                this.resolveEnum(schema, property);
            } else if (property instanceof EnumListProperty) {
                this.resolveList(schema, property);
            } else {
                this.resolveDefault(schema, property);
            }
        } else if (JsonBaseTool.isListClass(property.getType())) {
            this.resolveList(schema, property);
        } else {
            schema.put("type", JsonSchemaConstants.getTypeMapping().get(property.getType()));
            if (Date.class.getName().equals(property.getType())) {
                schema.put("format", "date-time");
            }
        }
        return schema;
    }

    private void resolveDefault(ObjectNode schema, Property property) {
        ArrayNode enumNames;
        ArrayNode enumList;
        if (JsonBaseTool.isListClass(property.getType())) {
            schema.put("type", JsonSchemaConstants.getTypeMapping().get(JsonBaseTool.getListType()));
            ObjectNode items = schema.putObject("items");
            items.put("type", JsonSchemaConstants.getTypeMapping().get(JsonBaseTool.getListInnerClassName(property.getType())));
            enumList = items.putArray("enum");
            enumNames = items.putArray("enumNames");
        } else {
            schema.put("type", JsonSchemaConstants.getTypeMapping().get(property.getType()));
            enumList = schema.putArray("enum");
            enumNames = schema.putArray("enumNames");
        }
        this.addEnumsToProperty(enumList, enumNames, property);
        if (property.getDefaultValue() != null) {
            schema.put("default", property.getStringDefaultValue());
        }
    }

    private void addEnumsToProperty(ArrayNode enumList, ArrayNode enumNames, Property property) {
        List<?> possibleValues = property.getPossibleValues();
        for (Object possibleValue : possibleValues) {
            String value = possibleValue.toString();
            if (NamedThing.class.isAssignableFrom(possibleValue.getClass())) {
                value = ((NamedThing)possibleValue).getName();
            }
            enumList.add(value);
            enumNames.add(property.getPossibleValuesDisplayName(possibleValue));
        }
    }

    private void resolveEnum(ObjectNode schema, Property property) {
        schema.put("type", "string");
        ArrayNode enumNames = schema.putArray("enumNames");
        ArrayNode enumValues = schema.putArray("enum");
        List<?> possibleValues = property.getPossibleValues();
        for (Object possibleValue : possibleValues) {
            enumValues.add(possibleValue.toString());
            enumNames.add(property.getPossibleValuesDisplayName(possibleValue));
        }
    }

    private void resolveList(ObjectNode schema, Property property) {
        String className = property.getType();
        schema.put("type", "array");
        ObjectNode items = JsonNodeFactory.instance.objectNode();
        schema.set("items", (JsonNode)items);
        if (property instanceof EnumListProperty) {
            this.resolveEnum(items, property);
        } else {
            items.put("type", JsonSchemaConstants.getTypeMapping().get(JsonBaseTool.getListInnerClassName(className)));
        }
    }

    private void addToRequired(ObjectNode schema, String name) {
        ArrayNode requiredNode = !schema.has("required") ? schema.putArray("required") : (ArrayNode)schema.get("required");
        requiredNode.add(name);
    }

    private ObjectNode processDefaultValues(Properties defaultProperties) {
        ObjectNode defaultValuesNode = JsonNodeFactory.instance.objectNode();
        List<NamedThing> nestedProperties = defaultProperties.getProperties();
        for (NamedThing namedThing : nestedProperties) {
            NamedThing currentNamedThing = defaultProperties.getProperty(namedThing.getName());
            if (currentNamedThing == null || !(currentNamedThing instanceof Property)) continue;
            Property currentProperty = (Property)currentNamedThing;
            defaultValuesNode.put(currentNamedThing.getName(), currentProperty.getStringValue());
        }
        return defaultValuesNode;
    }
}

