/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.serialize.jsonschema.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.PropertiesList;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.serialize.jsonschema.UiSchemaConstants;
import org.talend.daikon.serialize.jsonschema.mapping.FieldMapper;
import org.talend.daikon.serialize.jsonschema.mapping.Mapper;

public class NestedPropertiesFieldMapper
extends FieldMapper {
    public NestedPropertiesFieldMapper(String uiType) {
        super(uiType);
    }

    public NestedPropertiesFieldMapper(String uiAttribute, String uiType) {
        super(uiAttribute, uiType);
    }

    protected void setItems(ObjectNode schema, Widget widget) {
        ObjectNode items = JsonNodeFactory.instance.objectNode();
        schema.set("items", (JsonNode)items);
        super.setType(items);
        PropertiesList propertiesList = (PropertiesList)widget.getContent();
        Object defaultProp = propertiesList.getDefaultProperties();
        List<NamedThing> nestedThings = defaultProp.getProperties();
        ArrayNode uiOrderNode = JsonNodeFactory.instance.arrayNode();
        for (NamedThing namedThing : nestedThings) {
            uiOrderNode.add(namedThing.getName());
            Widget currentWidget = defaultProp.getPreferredForm("Main").getWidget(namedThing);
            Mapper uiMapper = UiSchemaConstants.getUiMappers().get(currentWidget.getWidgetType());
            if (uiMapper == null) continue;
            ObjectNode widgetNode = JsonNodeFactory.instance.objectNode();
            widgetNode.put("ui:widget", uiMapper.uiType);
            items.set(namedThing.getName(), (JsonNode)widgetNode);
        }
        items.set("ui:order", (JsonNode)uiOrderNode);
        this.processOptions(widget, items);
    }

    @Override
    public void processWidget(Widget widget, ObjectNode schema, boolean[] hasVisible) {
        if (widget.isAutoFocus()) {
            schema.put("ui:autofocus", true);
        }
        this.setItems(schema, widget);
        if (!"hidden".equals(this.uiType)) {
            hasVisible[0] = true;
        }
    }
}

