/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.AvroConverter;
import org.talend.daikon.avro.IndexedRecordAdapterFactory;
import org.talend.daikon.avro.util.ConvertBigDecimal;
import org.talend.daikon.avro.util.ConvertBigInteger;
import org.talend.daikon.avro.util.ConvertByte;
import org.talend.daikon.avro.util.ConvertCharacter;
import org.talend.daikon.avro.util.ConvertDate;
import org.talend.daikon.avro.util.ConvertInetAddress;
import org.talend.daikon.avro.util.ConvertShort;
import org.talend.daikon.avro.util.ConvertUUID;
import org.talend.daikon.avro.util.SingleColumnIndexedRecordAdapterFactory;
import org.talend.daikon.java8.SerializableFunction;
import org.talend.daikon.java8.SerializableSupplier;
import org.talend.daikon.java8.Supplier;

public class AvroRegistry {
    private Map<Class<?>, SerializableFunction<?, ?>> mapSchemaInferrer = new HashMap();
    private static Map<Class<?>, AvroConverter<?, ?>> mapSharedConverter = new HashMap();
    private Map<Class<?>, AvroConverter<?, ?>> mapConverter = new HashMap();
    private static Map<Class<?>, SerializableSupplier<? extends IndexedRecordAdapterFactory<?, ?>>> mapSharedAdapterFactory = new HashMap();

    public <DatumT> void registerSchemaInferrer(Class<DatumT> datumClass, SerializableFunction<? super DatumT, Schema> inferrer) {
        this.mapSchemaInferrer.put(datumClass, inferrer);
    }

    private static <DatumT> void registerSharedPrimitiveClass(Class<DatumT> primitiveClass, Schema schema) {
        mapSharedConverter.put(primitiveClass, new Unconverted<DatumT>(primitiveClass, schema));
        mapSharedAdapterFactory.put(primitiveClass, new LambdaSingleColumnIndexedRecordAdapterFactorySupplier<DatumT>(primitiveClass, schema));
    }

    private static <DatumT> void registerSharedPrimitiveClass(Class<DatumT> primitiveClass, AvroConverter<DatumT, ?> converter) {
        mapSharedConverter.put(primitiveClass, converter);
        mapSharedAdapterFactory.put(primitiveClass, new LambdaSingleColumnIndexedRecordAdapterFactorySupplier<DatumT>(primitiveClass, converter.getSchema()));
    }

    public <DatumT> Schema inferSchema(DatumT datum) {
        if (datum == null) {
            return null;
        }
        LambdaReturnConstantSchemaFunction inferrer = (LambdaReturnConstantSchemaFunction)AvroRegistry.getFromClassRegistry(this.mapSchemaInferrer, datum.getClass());
        if (inferrer == null) {
            AvroConverter<?, ?> converter = this.getConverter(datum.getClass());
            if (converter != null) {
                inferrer = new LambdaReturnConstantSchemaFunction(converter.getSchema());
            }
            this.mapSchemaInferrer.put(datum.getClass(), inferrer);
        }
        if (inferrer == null) {
            throw new RuntimeException("Cannot infer the schema from " + datum.getClass());
        }
        return (Schema)inferrer.apply(datum);
    }

    public <DatumT> void registerConverter(Class<DatumT> specificClass, AvroConverter<DatumT, ?> avroConverter) {
        this.mapConverter.put(specificClass, avroConverter);
    }

    public <T> AvroConverter<T, ?> getConverter(Class<T> datumClass) {
        AvroConverter converter = (AvroConverter)AvroRegistry.getFromClassRegistry(this.mapConverter, datumClass);
        if (converter != null) {
            return converter;
        }
        return (AvroConverter)AvroRegistry.getFromClassRegistry(mapSharedConverter, datumClass);
    }

    protected <DatumT, AdapterFactoryT extends IndexedRecordAdapterFactory<? super DatumT, ?>> void registerAdapterFactory(Class<DatumT> datumClass, Class<AdapterFactoryT> adapterFactoryClass) {
        mapSharedAdapterFactory.put(datumClass, new LambdaCreateANewInstanceSupplier<DatumT, AdapterFactoryT>(datumClass, adapterFactoryClass));
    }

    protected <T> void registerAdapterFactory(Class<T> datumClass, SerializableSupplier<? extends IndexedRecordAdapterFactory<? super T, ?>> adapterFactoryFactory) {
        mapSharedAdapterFactory.put(datumClass, adapterFactoryFactory);
    }

    public <DatumT> IndexedRecordAdapterFactory<? super DatumT, ?> createAdapterFactory(Class<DatumT> datumClass) {
        Supplier adapterFactory = (Supplier)AvroRegistry.getFromClassRegistry(mapSharedAdapterFactory, datumClass);
        if (adapterFactory == null && IndexedRecord.class.isAssignableFrom(datumClass)) {
            UnconvertedIndexedRecordAdapterFactory unconverted = new UnconvertedIndexedRecordAdapterFactory();
            return unconverted;
        }
        return adapterFactory == null ? null : (IndexedRecordAdapterFactory)adapterFactory.get();
    }

    public static <T, T2 extends T> T2 getFromClassRegistry(Map<Class<?>, ? extends T> map, Class<?> datumClass) {
        if (datumClass == null) {
            return null;
        }
        Object match = map.get(datumClass);
        if (match != null) {
            return (T2)match;
        }
        match = AvroRegistry.getFromClassRegistry(map, datumClass.getSuperclass());
        if (match != null) {
            return (T2)match;
        }
        for (Class<?> iClass : datumClass.getInterfaces()) {
            match = AvroRegistry.getFromClassRegistry(map, iClass);
            if (match == null) continue;
            return (T2)match;
        }
        return null;
    }

    public static <T> T createANew(Class<T> cls, Object optionalParam) {
        try {
            return cls.getConstructor(optionalParam.getClass()).newInstance(optionalParam);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            try {
                return cls.newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static {
        AvroRegistry.registerSharedPrimitiveClass(String.class, Schema.create((Schema.Type)Schema.Type.STRING));
        AvroRegistry.registerSharedPrimitiveClass(ByteBuffer.class, Schema.create((Schema.Type)Schema.Type.BYTES));
        AvroRegistry.registerSharedPrimitiveClass(Integer.class, Schema.create((Schema.Type)Schema.Type.INT));
        AvroRegistry.registerSharedPrimitiveClass(Long.class, Schema.create((Schema.Type)Schema.Type.LONG));
        AvroRegistry.registerSharedPrimitiveClass(Float.class, Schema.create((Schema.Type)Schema.Type.FLOAT));
        AvroRegistry.registerSharedPrimitiveClass(Double.class, Schema.create((Schema.Type)Schema.Type.DOUBLE));
        AvroRegistry.registerSharedPrimitiveClass(Boolean.class, Schema.create((Schema.Type)Schema.Type.BOOLEAN));
        AvroRegistry.registerSharedPrimitiveClass(Byte.class, new ConvertByte());
        AvroRegistry.registerSharedPrimitiveClass(Character.class, new ConvertCharacter());
        AvroRegistry.registerSharedPrimitiveClass(Short.class, new ConvertShort());
        AvroRegistry.registerSharedPrimitiveClass(BigDecimal.class, new ConvertBigDecimal());
        AvroRegistry.registerSharedPrimitiveClass(BigInteger.class, new ConvertBigInteger());
        AvroRegistry.registerSharedPrimitiveClass(Date.class, new ConvertDate());
        AvroRegistry.registerSharedPrimitiveClass(InetAddress.class, new ConvertInetAddress());
        AvroRegistry.registerSharedPrimitiveClass(UUID.class, new ConvertUUID());
    }

    private static class LambdaCreateANewInstanceSupplier<DatumT, AdapterFactoryT extends IndexedRecordAdapterFactory<? super DatumT, ?>>
    implements SerializableSupplier<AdapterFactoryT> {
        private static final long serialVersionUID = 1L;
        private final Class<DatumT> datumClass;
        private final Class<AdapterFactoryT> adapterFactoryClass;

        public LambdaCreateANewInstanceSupplier(Class<DatumT> datumClass, Class<AdapterFactoryT> adapterFactoryClass) {
            this.datumClass = datumClass;
            this.adapterFactoryClass = adapterFactoryClass;
        }

        @Override
        public AdapterFactoryT get() {
            return (AdapterFactoryT)((IndexedRecordAdapterFactory)AvroRegistry.createANew(this.adapterFactoryClass, this.datumClass));
        }
    }

    private static class LambdaSingleColumnIndexedRecordAdapterFactorySupplier<DatumT>
    implements SerializableSupplier<SingleColumnIndexedRecordAdapterFactory<DatumT>> {
        private static final long serialVersionUID = 1L;
        private final Class<DatumT> primitiveClass;
        private final Schema schema;

        public LambdaSingleColumnIndexedRecordAdapterFactorySupplier(Class<DatumT> primitiveClass, Schema schema) {
            this.primitiveClass = primitiveClass;
            this.schema = schema;
        }

        @Override
        public SingleColumnIndexedRecordAdapterFactory<DatumT> get() {
            return new SingleColumnIndexedRecordAdapterFactory<DatumT>(this.primitiveClass, this.schema);
        }
    }

    private static class LambdaReturnConstantSchemaFunction<DatumT>
    implements SerializableFunction<DatumT, Schema> {
        private static final long serialVersionUID = 1L;
        private final Schema schema;

        public LambdaReturnConstantSchemaFunction(Schema schema) {
            this.schema = schema;
        }

        @Override
        public Schema apply(DatumT t) {
            return this.schema;
        }
    }

    public static class UnconvertedIndexedRecordAdapterFactory<T extends IndexedRecord>
    implements IndexedRecordAdapterFactory<T, IndexedRecord> {
        private Schema mSchema;

        @Override
        public Schema getSchema() {
            return this.mSchema;
        }

        @Override
        public void setSchema(Schema schema) {
            this.mSchema = schema;
        }

        @Override
        public Class<T> getDatumClass() {
            return null;
        }

        @Override
        public IndexedRecord convertToAvro(T value) {
            return value;
        }

        @Override
        public T convertToDatum(IndexedRecord value) {
            return (T)value;
        }
    }

    public static class Unconverted<T>
    implements AvroConverter<T, T> {
        private final Class<T> mSpecificClass;
        private final Schema mSchema;

        public Unconverted(Class<T> specificClass, Schema schema) {
            this.mSpecificClass = specificClass;
            this.mSchema = schema;
        }

        @Override
        public Schema getSchema() {
            return this.mSchema;
        }

        @Override
        public Class<T> getDatumClass() {
            return this.mSpecificClass;
        }

        @Override
        public T convertToDatum(T value) {
            return value;
        }

        @Override
        public T convertToAvro(T value) {
            return value;
        }
    }
}

