/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroConverter;
import org.talend.daikon.avro.util.ConvertBigDecimal;
import org.talend.daikon.avro.util.ConvertByte;
import org.talend.daikon.avro.util.ConvertCharacter;
import org.talend.daikon.avro.util.ConvertDate;
import org.talend.daikon.avro.util.ConvertShort;

public class AvroTypes {
    private static final AvroConverter BYTE_TYPE = new ConvertByte();
    private static final AvroConverter CHARACTER_TYPE = new ConvertCharacter();
    private static final AvroConverter DATE_TYPE = new ConvertDate();
    private static final AvroConverter SHORT_TYPE = new ConvertShort();
    private static final AvroConverter DECIMAL_TYPE = new ConvertBigDecimal();

    public static Schema _boolean() {
        return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    }

    public static Schema _byte() {
        return BYTE_TYPE.getSchema();
    }

    public static Schema _bytes() {
        return Schema.create((Schema.Type)Schema.Type.BYTES);
    }

    public static Schema _character() {
        return CHARACTER_TYPE.getSchema();
    }

    public static Schema _date() {
        return DATE_TYPE.getSchema();
    }

    public static Schema _double() {
        return Schema.create((Schema.Type)Schema.Type.DOUBLE);
    }

    public static Schema _float() {
        return Schema.create((Schema.Type)Schema.Type.FLOAT);
    }

    public static Schema _int() {
        return Schema.create((Schema.Type)Schema.Type.INT);
    }

    public static Schema _long() {
        return Schema.create((Schema.Type)Schema.Type.LONG);
    }

    public static Schema _short() {
        return SHORT_TYPE.getSchema();
    }

    public static Schema _string() {
        return Schema.create((Schema.Type)Schema.Type.STRING);
    }

    public static Schema _decimal() {
        return DECIMAL_TYPE.getSchema();
    }

    public static boolean isSameType(Schema actual, Schema expect) {
        String expectJavaClass = expect.getProp("java-class");
        String actualJavaClass = actual.getProp("java-class");
        return actual.getType() == expect.getType() && (actualJavaClass == null ? expectJavaClass == null : actualJavaClass.equals(expectJavaClass));
    }
}

