/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public class AvroUtils {
    public static boolean isNullable(Schema schema) {
        if (schema.getType() == Schema.Type.NULL) {
            return true;
        }
        if (schema.getType() == Schema.Type.UNION) {
            for (Schema unionType : schema.getTypes()) {
                if (unionType.getType() != Schema.Type.NULL) continue;
                return true;
            }
        }
        return false;
    }

    public static Schema wrapAsNullable(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            List unionTypes = schema.getTypes();
            if (unionTypes.contains(Schema.create((Schema.Type)Schema.Type.NULL))) {
                return schema;
            }
            ArrayList<Schema> typesWithNullable = new ArrayList<Schema>(unionTypes);
            typesWithNullable.add(Schema.create((Schema.Type)Schema.Type.NULL));
            return Schema.createUnion(typesWithNullable);
        }
        return (Schema)SchemaBuilder.nullable().type(schema);
    }

    public static Schema unwrapIfNullable(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            List unionTypes = schema.getTypes();
            if (unionTypes.size() == 2) {
                if (((Schema)unionTypes.get(0)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)unionTypes.get(1);
                }
                if (((Schema)unionTypes.get(1)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)unionTypes.get(0);
                }
            } else if (unionTypes.contains(Schema.create((Schema.Type)Schema.Type.NULL))) {
                ArrayList typesWithoutNullable = new ArrayList(unionTypes);
                typesWithoutNullable.remove(Schema.create((Schema.Type)Schema.Type.NULL));
                return Schema.createUnion(typesWithoutNullable);
            }
        }
        return schema;
    }

    public static Map<String, Schema.Field> makeFieldMap(Schema schema) {
        HashMap<String, Schema.Field> map = new HashMap<String, Schema.Field>();
        for (Schema.Field field : schema.getFields()) {
            map.put(field.name(), field);
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Schema setProperty(Schema schema, String key, String value) {
        Schema newSchema = schema;
        if (schema.getProp(key) != null) {
            if (schema.getType() != Schema.Type.RECORD) throw new RuntimeException("Not support this type " + newSchema.getType() + " now, need to implement");
            newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
            ArrayList<Schema.Field> copyFieldList = new ArrayList<Schema.Field>();
            for (Schema.Field se : schema.getFields()) {
                copyFieldList.add(new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal()));
            }
            newSchema.setFields(copyFieldList);
            Map props = schema.getObjectProps();
            for (String propKey : props.keySet()) {
                if (propKey.equals(key)) {
                    newSchema.addProp(key, value);
                    continue;
                }
                newSchema.addProp(propKey, props.get(propKey));
            }
            return newSchema;
        } else {
            schema.addProp(key, value);
        }
        return newSchema;
    }

    public static boolean isIncludeAllFields(Schema schema) {
        String prop = schema.getProp("include-all-fields");
        return prop != null && Boolean.valueOf(prop) != false;
    }

    public static Schema setIncludeAllFields(Schema schema, boolean value) {
        return AvroUtils.setProperty(schema, "include-all-fields", String.valueOf(value));
    }
}

