/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroConverter;
import org.talend.daikon.avro.util.HasNestedAvroConverter;
import org.talend.daikon.avro.util.MappedList;
import org.talend.daikon.java8.SerializableFunction;

public class ConvertAvroList<DatumT, AvroT>
implements HasNestedAvroConverter<List<DatumT>, List<AvroT>> {
    private Schema schema;
    private Class<List<DatumT>> datumClass;
    private final AvroConverter<DatumT, AvroT> elementConverter;

    public ConvertAvroList(Class<List<DatumT>> datumClass, Schema schema, AvroConverter<DatumT, AvroT> elementConverter) {
        this.datumClass = datumClass;
        this.schema = schema;
        this.elementConverter = elementConverter;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Class<List<DatumT>> getDatumClass() {
        return this.datumClass;
    }

    @Override
    public List<DatumT> convertToDatum(List<AvroT> value) {
        return Collections.unmodifiableList(new MappedList<AvroT, DatumT>(value, new LambdaConvertToDatumFunction<AvroT, DatumT>(this.elementConverter), new LambdaConvertToAvroFunction<DatumT, AvroT>(this.elementConverter)));
    }

    @Override
    public List<AvroT> convertToAvro(List<DatumT> value) {
        return Collections.unmodifiableList(new MappedList<DatumT, AvroT>(value, new LambdaConvertToAvroFunction<DatumT, AvroT>(this.elementConverter), new LambdaConvertToDatumFunction<AvroT, DatumT>(this.elementConverter)));
    }

    @Override
    public List<AvroConverter<?, ?>> getNestedAvroConverters() {
        return Arrays.asList(this.elementConverter);
    }

    public static class LambdaConvertToAvroFunction<DatumT, AvroT>
    implements SerializableFunction<DatumT, AvroT> {
        private static final long serialVersionUID = 1L;
        private final AvroConverter<DatumT, AvroT> elementConverter;

        public LambdaConvertToAvroFunction(AvroConverter<DatumT, AvroT> elementConverter) {
            this.elementConverter = elementConverter;
        }

        @Override
        public AvroT apply(DatumT value) {
            return this.elementConverter.convertToAvro(value);
        }
    }

    public static class LambdaConvertToDatumFunction<AvroT, DatumT>
    implements SerializableFunction<AvroT, DatumT> {
        private static final long serialVersionUID = 1L;
        private final AvroConverter<DatumT, AvroT> elementConverter;

        public LambdaConvertToDatumFunction(AvroConverter<DatumT, AvroT> elementConverter) {
            this.elementConverter = elementConverter;
        }

        @Override
        public DatumT apply(AvroT value) {
            return this.elementConverter.convertToDatum(value);
        }
    }
}

